<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method shareOrderDataByParams(array $params)
 * @method setShareOrderByParams(array $params)
 * @method shareOrderlistByParams(array $params)
 * @method deleteShareOrderByParams(array $params)
 */
class ShareOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取晒单内容
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function shareOrderData () {
        return self::getClass()->shareOrderData();
    }

    /**
     * 添加晒单
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @support  array $share_data 晒单数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setShareOrder () {
        return self::getClass()->setShareOrder();
    }

    /**
     * 买家秀列表
     *
     * @support  int $category_id 类目id [ require true ]
     * @support  int $page 页数 
     * @support  int $page_size 每页条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function shareOrderlist () {
        return self::getClass()->shareOrderlist();
    }

    /**
     * 删除买家秀
     *
     * @support  int $category_id 类目id [ require true ]
     * @support  int $order_num 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteShareOrder () {
        return self::getClass()->deleteShareOrder();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\ShareOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\ShareOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}