<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method groupPayCreateByParams(array $params)
 * @method closeByParams(array $params)
 * @method zeroByParams(array $params)
 * @method callbackByParams(array $params)
 */
class Pay {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建支付
     *
     * @support  string $order_num 订单号 
     * @support  float $pay_money 金额 [Original type unsignedDouble] [ require true ]
     * @support  string $open_id 用户openId 
     * @support  string $sub_order_num 二销订单编号 
     * @support  array $retail_order_num 零售订单编号 
     * @support  string $offline_order_num 线下订单编号 
     * @support  array $pay_order_money 支付金额组合 
     * @support  int $send_url_staff_id 发送支付链接小伙伴 
     * @support  string $pay_url_create_time 支付链接创建时间 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 团购订单创建
     *
     * @support  string $group_order_num 团购订单号 [ require true ]
     * @support  float $pay_money 支付金额 [Original type unsignedDouble] [ require true ]
     * @support  int $pay_type 支付类型 [ require true ]
     * @support  string $open_id openid 
     * @support  int $send_url_staff_id 发送支付链接小伙伴 
     * @support  string $pay_url_create_time 支付链接创建时间 
     * @throws  \Exception
     * @return  array
     */
    public static function groupPayCreate () {
        return self::getClass()->groupPayCreate();
    }

    /**
     * 关闭支付
     *
     * @support  string $order_num 订单号 
     * @support  string $sub_order_num 子订单号 
     * @support  string $retail_order_num 零售订单号 
     * @support  string $offline_order_num 线下订单号 
     * @support  string $group_order_num 团购订单号 
     * @support  int $group_order_type 团购订单支付类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function close () {
        return self::getClass()->close();
    }

    /**
     * 零元支付
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function zero () {
        return self::getClass()->zero();
    }

    /**
     * 支付回调
     *
     * @support  string $data 交易返回数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function callback () {
        return self::getClass()->callback();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\Pay');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\Pay');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}