<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method appointmentHomePageByParams(array $params)
 * @method enableAppointmentTimeListByParams(array $params)
 * @method setAppointmentTimeByParams(array $params)
 * @method updateAppointmentTimeByParams(array $params)
 * @method cancelAppointmentTimeByParams(array $params)
 * @method allowLookPhotoStoreListByParams(array $params)
 * @method allowLookPhotoCityByParams(array $params)
 */
class AppointmentLookPhoto {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预约看片首页
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function appointmentHomePage () {
        return self::getClass()->appointmentHomePage();
    }

    /**
     * 可预约看片时间列表
     *
     * @support  int $store_id 门店id [ require true ]
     * @support  string $date_start 开始日期 [ require true ]
     * @support  string $date_end 结束日期 [ require true ]
     * @support  string $order_num 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function enableAppointmentTimeList () {
        return self::getClass()->enableAppointmentTimeList();
    }

    /**
     * 设置预约看片时间
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @support  string $appointment_time 预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setAppointmentTime () {
        return self::getClass()->setAppointmentTime();
    }

    /**
     * 更改预约看片时间
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @support  string $appointment_time 预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateAppointmentTime () {
        return self::getClass()->updateAppointmentTime();
    }

    /**
     * 取消预约看片时间
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelAppointmentTime () {
        return self::getClass()->cancelAppointmentTime();
    }

    /**
     * 获取可看片门店
     *
     * @support  string $city_id 城市id [ require true ]
     * @support  string $date 日期 [ require true ]
     * @support  string $order_num 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function allowLookPhotoStoreList () {
        return self::getClass()->allowLookPhotoStoreList();
    }

    /**
     * 获取可预约看片城市
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function allowLookPhotoCity () {
        return self::getClass()->allowLookPhotoCity();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\AppointmentLookPhoto');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\AppointmentLookPhoto');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}