<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method encodeOrderDetailByParams(array $params)
 * @method encodeSubOrderDetailByParams(array $params)
 * @method encodeRetailOrderDetailByParams(array $params)
 * @method encodeOfflineOrderDetailByParams(array $params)
 * @method hookCloseOrderByParams(array $params)
 * @method firstClickByParams(array $params)
 * @method cancelByParams(array $params)
 * @method deleteByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method bindByParams(array $params)
 * @method photoByParams(array $params)
 * @method icbcPhotoByParams(array $params)
 * @method refundByParams(array $params)
 * @method orderCompleteByParams(array $params)
 * @method sendKfMessageByParams(array $params)
 * @method sendRetailKfMessageByParams(array $params)
 * @method sendKidsMessageByParams(array $params)
 * @method sendMantuXxzMessageByParams(array $params)
 * @method paySuccessSendNoticeByParams(array $params)
 * @method yuanyangKfMsgByParams(array $params)
 * @method reasonByParams(array $params)
 * @method photoTemplatesByParams(array $params)
 * @method sendNormalNotifyByParams(array $params)
 * @method subOrderServiceCompleteInfoByParams(array $params)
 * @method subOrderServiceCompleteByParams(array $params)
 * @method babyInfoByParams(array $params)
 * @method checkOccByParams(array $params)
 * @method checkOccByStoreIdsByParams(array $params)
 * @method groupOrderInfoByParams(array $params)
 * @method gestationalWeekByParams(array $params)
 * @method sendMessageByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @support  string $user_phone 用户手机号 [ require true ]
     * @support  string $user_sex 用户性别 [ require true ]
     * @support  string $user_name 用户姓名 [ require true ]
     * @support  string $user_birthday 用户生日 [ require true ]
     * @support  string $reserve_time 预约时间 [ require true ]
     * @support  array $detail 订单详情(商品&amp;服务详情) [ require true ]
     * @support  float $ori_money 原始价格 [Original type unsignedDouble] [ require true ]
     * @support  float $gift_card_money 礼品卡抵扣金额 [Original type double] 
     * @support  int $coupon_id 优惠券ID 
     * @support  float $coupon_deduction_money 优惠券优惠金额 [Original type unsignedDouble] 
     * @support  int $product_card_id 产品卡ID 
     * @support  float $product_card_deduction_money 产品卡优惠金额 [Original type unsignedDouble] 
     * @support  array $product_discount_ids 组合优惠id 
     * @support  float $product_discount_deduction_money 组合优惠优惠金额 [Original type unsignedDouble] 
     * @support  int $store_id 门店id [ require true ]
     * @support  int $channel 渠道号 
     * @support  int $gestational_week 孕周 
     * @support  string $note 备注 
     * @support  string $contact 联系人 
     * @support  string $platform 平台 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取订单列表
     *
     * @support  string $status 订单状态-total:全部,wait:待拍摄,today:当日拍摄,complete:已完成,close:已关闭 [ require true ]
     * @support  int $page 页数 
     * @support  int $page_size 每页条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取订单详情
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 获取加密订单详情
     *
     * @param  string $encode_order_num 加密的订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function encodeOrderDetail (string $encode_order_num) {
        return self::getClass()->encodeOrderDetail([
            "encode_order_num" => $encode_order_num,
        ]);
    }

    /**
     * 获取加密子订单详情
     *
     * @support  string $encode_order_num 加密的订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function encodeSubOrderDetail () {
        return self::getClass()->encodeSubOrderDetail();
    }

    /**
     * 获取加密零售订单详情
     *
     * @support  string $encode_order_num 加密的订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function encodeRetailOrderDetail () {
        return self::getClass()->encodeRetailOrderDetail();
    }

    /**
     * 获取加密线下订单详情
     *
     * @support  string $encode_order_num 加密的订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function encodeOfflineOrderDetail () {
        return self::getClass()->encodeOfflineOrderDetail();
    }

    /**
     * 关闭订单
     *
     * @param  array $orderObject 订单数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCloseOrder (array $orderObject) {
        return self::getClass()->hookCloseOrder([
            "orderObject" => $orderObject,
        ]);
    }

    /**
     * 第一次进入支付链接(仅限拍摄订单)
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function firstClick (string $orderNum) {
        return self::getClass()->firstClick([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 取消未支付订单
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel () {
        return self::getClass()->cancel();
    }

    /**
     * 删除订单
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 修改预约时间
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  string $reserve_time 新预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeReserveTime () {
        return self::getClass()->changeReserveTime();
    }

    /**
     * 绑定订单
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bind () {
        return self::getClass()->bind();
    }

    /**
     * 获取云端原片地址
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function photo () {
        return self::getClass()->photo();
    }

    /**
     * icbc真我卡获取云端原片地址
     *
     * @support  int $user_id 用户id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function icbcPhoto () {
        return self::getClass()->icbcPhoto();
    }

    /**
     * 申请退款
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  array $reason_ids 退款原因ids 
     * @support  string $reason 退款原因 
     * @throws  \Exception
     * @return  mixed
     */
    public static function refund () {
        return self::getClass()->refund();
    }

    /**
     * 订单完成推送通知
     *
     * @support  int $orderId 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderComplete () {
        return self::getClass()->orderComplete();
    }

    /**
     * 婚礼照推送
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendKfMessage () {
        return self::getClass()->sendKfMessage();
    }

    /**
     * 零售客服消息
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendRetailKfMessage () {
        return self::getClass()->sendRetailKfMessage();
    }

    /**
     * 小幸运kids营销推送
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendKidsMessage () {
        return self::getClass()->sendKidsMessage();
    }

    /**
     * 缦图形象照客服消息
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendMantuXxzMessage () {
        return self::getClass()->sendMantuXxzMessage();
    }

    /**
     * 支付成功推送
     *
     * @support  array $wxData 微信发送参数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function paySuccessSendNotice () {
        return self::getClass()->paySuccessSendNotice();
    }

    /**
     * 鸳鸯照推送
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function yuanyangKfMsg () {
        return self::getClass()->yuanyangKfMsg();
    }

    /**
     * 退款理由
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reason () {
        return self::getClass()->reason();
    }

    /**
     * 获取照片模板
     *
     * @param  array $product_ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function photoTemplates (array $product_ids) {
        return self::getClass()->photoTemplates([
            "product_ids" => $product_ids,
        ]);
    }

    /**
     * 看片通知
     *
     * @support  int $order_id 订单id [Original type uint] [ require true ]
     * @support  string $type 类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendNormalNotify () {
        return self::getClass()->sendNormalNotify();
    }

    /**
     * 获取是否需要确认子订单
     *
     * @param  string $order_no 订单号 [ require true ]
     * @param  array $sub_order_item_ids 子订单项 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function subOrderServiceCompleteInfo (string $order_no, array $sub_order_item_ids = []) {
        return self::getClass()->subOrderServiceCompleteInfo([
            "order_no" => $order_no,
            "sub_order_item_ids" => $sub_order_item_ids,
        ]);
    }

    /**
     * 子订单确认
     *
     * @param  array $sub_order_ids 需要确认收入的子订单 [ require true ]
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function subOrderServiceComplete (string $order_no, array $sub_order_ids) {
        return self::getClass()->subOrderServiceComplete([
            "order_no" => $order_no,
            "sub_order_ids" => $sub_order_ids,
        ]);
    }

    /**
     * 更新订单婴儿信息
     *
     * @support  string $_id _id [ require true ]
     * @support  string $baby_name 宝贝名 
     * @support  string $baby_birth 宝贝生日 
     * @throws  \Exception
     * @return  mixed
     */
    public static function babyInfo () {
        return self::getClass()->babyInfo();
    }

    /**
     * 检查全家福每日的占点
     *
     * @support  int $store_id 门店id [Original type uint] [ require true ]
     * @support  string $start_at 开始时间 [ require true ]
     * @support  string $end_at 结束时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkOcc () {
        return self::getClass()->checkOcc();
    }

    /**
     * 检查全家福每日的占点
     *
     * @support  array $store_ids 门店ids [ require true ]
     * @support  string $date 时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkOccByStoreIds () {
        return self::getClass()->checkOccByStoreIds();
    }

    /**
     * 获取团购订单详情
     *
     * @support  string $group_order_num 团购订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function groupOrderInfo () {
        return self::getClass()->groupOrderInfo();
    }

    /**
     * 查询记录的孕周信息
     *
     * @support  string $start_at 开始时间 
     * @support  string $end_at 结束时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function gestationalWeek () {
        return self::getClass()->gestationalWeek();
    }

    /**
     * 推送客服消息
     *
     * @support  int $user_id 用户id [ require true ]
     * @support  array $message_text 文字消息 
     * @support  array $image_media 图片消息 
     * @support  array $article_media 图文消息 
     * @support  array $rule 图文消息规则 
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendMessage () {
        return self::getClass()->sendMessage();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}