<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method createByParams(array $params)
 * @method editByParams(array $params)
 * @method setEndDateToNowByParams(array $params)
 * @method removeActivityByParams(array $params)
 * @method getSkuListByParams(array $params)
 */
class RetailActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 活动列表
     *
     * @support  string $name 活动标题 
     * @support  string $status 活动状态 
     * @support  int $page 当前页 
     * @support  int $pageSize 页内条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 活动详情
     *
     * @support  int $id 活动id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 创建活动
     *
     * @support  string $name 活动名称 [ require true ]
     * @support  string $type 活动类型 [ require true ]
     * @support  int $offlinePromotions 线下活动:1 是 0 否(现在必须是线下) [ require true ]
     * @support  int $offerOverlay 优惠叠加:1 是 0 否 [ require true ]
     * @support  string $startedAt 有效期开始时间 
     * @support  string $endedAt 有效期结束时间 
     * @support  array $storeIds 活动关联店铺 [ require true ]
     * @support  array $skuIds 商品的sku_id [ require true ]
     * @support  array $rules 活动规则 
     * @support  array $giveawaySkuIds 赠品的sku_id 
     * @support  array $categoryIds 全选的商品分类ids（商品如果添加，会自动关联上促销活动） 
     * @support  array $giveawayCategoryIds 赠品全选的分类 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 编辑活动
     *
     * @support  int $id 活动id [ require true ]
     * @support  string $name 活动名称 
     * @support  string $type 活动类型 
     * @support  int $offlinePromotions 线下活动:1 是 0 否(现在必须是线下) [ require true ]
     * @support  int $offerOverlay 优惠叠加:1 是 0 否 [ require true ]
     * @support  string $startedAt 有效期开始时间 
     * @support  string $endedAt 有效期结束时间 
     * @support  array $storeIds 活动关联店铺 [ require true ]
     * @support  array $skuIds 商品的sku_id [ require true ]
     * @support  array $rules 活动规则 
     * @support  array $giveawaySkuIds 赠品的sku_id 
     * @support  array $categoryIds 全选的商品分类ids（商品如果添加，会自动关联上促销活动） 
     * @support  array $giveawayCategoryIds 赠品全选的分类 
     * @throws  \Exception
     * @return  mixed
     */
    public static function edit () {
        return self::getClass()->edit();
    }

    /**
     * 设置终止时间为当前
     *
     * @support  int $id 活动id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setEndDateToNow () {
        return self::getClass()->setEndDateToNow();
    }

    /**
     * 删除活动
     *
     * @support  int $id 活动id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeActivity () {
        return self::getClass()->removeActivity();
    }

    /**
     * 获取sku列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSkuList () {
        return self::getClass()->getSkuList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\RetailActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\RetailActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}