<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchCreateByParams(array $params)
 * @method abolishedByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method searchByParams(array $params)
 * @method createLogListByParams(array $params)
 * @method jxjyCouponByParams(array $params)
 * @method antiVirusCouponByParams(array $params)
 */
class PreferentialCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量生成优惠券
     *
     * @support  string $title 标题 [ require true ]
     * @support  int $template_id 模板id [Original type uint] [ require true ]
     * @support  int $count 创建数量 [Original type uint] [ require true ]
     * @support  float $discount 折扣 [Original type double] [ require true ]
     * @support  float $ori_money 原金额 [Original type unsignedDouble] 
     * @support  string $stop_usage 结束使用时间 
     * @support  string $start_usage 开始生效时间 
     * @support  float $pay_money 收金额 [Original type unsignedDouble] 
     * @support  string $buy_channel 购买渠道 
     * @support  int $sale_store_id 售卖门店 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate () {
        return self::getClass()->batchCreate();
    }

    /**
     * 优惠券作废
     *
     * @support  array $codes 优惠码code数组 [ require true ]
     * @support  array $extend 额外信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function abolished () {
        return self::getClass()->abolished();
    }

    /**
     * 获取兑换码列表(分页)
     *
     * @support  string $type 优惠券类型 
     * @support  string $mobile 手机号 
     * @support  int $user_id 用户id [Original type uint] 
     * @support  string $created_at_start 生成时间起 
     * @support  string $created_at_end 生成时间止 
     * @support  string $used_at_start 使用时间起 
     * @support  string $used_at_end 使用时间止 
     * @support  string $status 状态 
     * @support  string $code 兑换码 
     * @support  int $create_log_id 创建记录id [Original type uint] 
     * @support  bool $with_template_info 包含卡面信息 
     * @support  int $page 页码 
     * @support  int $page_size 每页条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取兑换码列表(所有)
     *
     * @support  string $mobile 手机号 
     * @support  string $type 优惠券类型 
     * @support  int $user_id 用户id [Original type uint] 
     * @support  string $created_at_start 生成时间起 
     * @support  string $created_at_end 生成时间止 
     * @support  string $used_at_start 使用时间起 
     * @support  string $used_at_end 使用时间止 
     * @support  string $status 状态 
     * @support  array $code 兑换码 
     * @support  int $create_log_id 创建记录id [Original type uint] 
     * @support  bool $with_template_info 包含卡面信息 
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 优惠券单个码查询
     *
     * @support  string $mobile 手机号 
     * @support  string $status 状态 
     * @support  string $code 兑换码 
     * @support  int $product_id 适用产品 
     * @support  int $store_id 适用门店 
     * @support  bool $action_scope 是否可以用于升级服务 
     * @support  string $description 描述 
     * @support  string $used_at_end 使用时间止 
     * @support  string $used_at_start 使用时间起 
     * @support  int $page 页码 
     * @support  int $page_size 每页条数 
     * @throws  \Exception
     * @return  array
     */
    public static function search () {
        return self::getClass()->search();
    }

    /**
     * 优惠券渠道领券查询
     *
     * @support  int $channel 渠道号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createLogList () {
        return self::getClass()->createLogList();
    }

    /**
     * 获取用户加修加印券
     *
     * @param  int $user_id 用户id [Original type uint] [ require true ]
     * @param  array $product_ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function jxjyCoupon (int $user_id, array $product_ids) {
        return self::getClass()->jxjyCoupon([
            "user_id" => $user_id,
            "product_ids" => $product_ids,
        ]);
    }

    /**
     * 抗疫发券
     *
     * @support  array $phones 手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function antiVirusCoupon () {
        return self::getClass()->antiVirusCoupon();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\PreferentialCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\PreferentialCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}