<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSupplyChainStaffsByParams(array $params)
 * @method getSubjectsByParams(array $params)
 * @method submitByParams(array $params)
 * @method getInventoriesByParams(array $params)
 * @method getInventoryByParams(array $params)
 * @method saveByParams(array $params)
 * @method passByParams(array $params)
 * @method rejectByParams(array $params)
 * @method exportInventoryByParams(array $params)
 * @method getStocksByParams(array $params)
 * @method getStockByParams(array $params)
 * @method exportStockByParams(array $params)
 */
class SupplyChain {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取供应链员工列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSupplyChainStaffs () {
        return self::getClass()->getSupplyChainStaffs();
    }

    /**
     * 获取子公司数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSubjects () {
        return self::getClass()->getSubjects();
    }

    /**
     * 提交盘点结果(总部)
     *
     * @support  int $id 盘点id [Original type uint] 
     * @param  int $staffId 员工工号 [Original type uint] [ require true ]
     * @param  int $locType 盘点类型 [Original type uint] [ require true ]
     * @param  array $materialInfo 物料信息 [ require true ]
     * @param  string $applyIn 总部/门店 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submit (int $staffId, int $locType, array $materialInfo, string $applyIn = 'store') {
        return self::getClass()->submit([
            "staffId" => $staffId,
            "locType" => $locType,
            "materialInfo" => $materialInfo,
            "applyIn" => $applyIn,
        ]);
    }

    /**
     * 获取盘点数据记录
     *
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  int $subjectId 子公司id [Original type uint] 
     * @support  int $storeId 门店id [Original type uint] 
     * @support  int $staffId 员工id [Original type uint] 
     * @support  int $locType 盘点类型 [Original type uint] 
     * @support  string $status 盘点状态 
     * @param  string $applyIn 总部/门店 [ require true ]
     * @support  string $checkStatus 审核状态 
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInventories (string $applyIn, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getInventories([
            "applyIn" => $applyIn,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取盘点记录详情
     *
     * @param  int $id 盘点id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInventory (int $id) {
        return self::getClass()->getInventory([
            "id" => $id,
        ]);
    }

    /**
     * 保存
     *
     * @param  int $id 盘点id [Original type uint] [ require true ]
     * @param  array $info 盘点信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function save (int $id, array $info) {
        return self::getClass()->save([
            "id" => $id,
            "info" => $info,
        ]);
    }

    /**
     * 通过
     *
     * @param  array $ids 盘点ids [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pass (array $ids) {
        return self::getClass()->pass([
            "ids" => $ids,
        ]);
    }

    /**
     * 驳回
     *
     * @param  array $ids 盘点ids [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reject (array $ids) {
        return self::getClass()->reject([
            "ids" => $ids,
        ]);
    }

    /**
     * 盘点导出
     *
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  int $storeId 门店id [Original type uint] 
     * @support  int $staffId 员工id [Original type uint] 
     * @support  int $locType 盘点类型 [Original type uint] 
     * @support  string $status 盘点状态 
     * @param  string $applyIn 总部/门店 [ require true ]
     * @support  string $checkStatus 审核状态 
     * @throws  \Exception
     * @return  array
     */
    public static function exportInventory (string $applyIn = 'store') {
        return self::getClass()->exportInventory([
            "applyIn" => $applyIn,
        ]);
    }

    /**
     * 获取库存数据
     *
     * @support  string $storeId 门店id 
     * @support  int $locType 仓库类型 [Original type uint] 
     * @support  int $safeQuantity 安全库存(1小于2等于3大于) [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStocks (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getStocks([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取库存
     *
     * @param  int $storeId 门店id [Original type uint] [ require true ]
     * @param  int $skuId sku id [Original type uint] [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStock (int $storeId, int $skuId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getStock([
            "storeId" => $storeId,
            "skuId" => $skuId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 库存导出
     *
     * @support  string $storeId 门店id 
     * @support  int $locType 仓库类型 [Original type uint] 
     * @support  int $safeQuantity 安全库存(1小于2等于3大于) [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function exportStock () {
        return self::getClass()->exportStock();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\SupplyChain');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\SupplyChain');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}