<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserInfoByParams(array $params)
 * @method chooseTypeByParams(array $params)
 * @method getProcessStaffByParams(array $params)
 * @method getAllStaffsByStoreByParams(array $params)
 * @method changeStatusByParams(array $params)
 * @method getMessageByParams(array $params)
 * @method getCurrentOrderByParams(array $params)
 * @method getOrderBaseInfoByParams(array $params)
 * @method getDresserRemarkByParams(array $params)
 * @method takeOrderByParams(array $params)
 * @method addReceptionRecordByParams(array $params)
 * @method dismissOrderByParams(array $params)
 * @method searchCurrentStoreStaffByParams(array $params)
 * @method giveOrderToStaffByParams(array $params)
 * @method giveOrderToStaffInManageByParams(array $params)
 * @method orderAgainByParams(array $params)
 * @method getLastQueueSortByParams(array $params)
 * @method adjustOrderStatusByParams(array $params)
 * @method staffWorkloadByParams(array $params)
 * @method changeStateByCloudByParams(array $params)
 * @method modifyOrderNoteByParams(array $params)
 * @method completeOrderByParams(array $params)
 * @method getOriginStaffIdByParams(array $params)
 * @method returnToMakeUpByParams(array $params)
 * @method getStaffStateByParams(array $params)
 * @method getOnlineOrderCountByParams(array $params)
 * @method getNowOrderListByParams(array $params)
 * @method sendTakeOrderNoticeByParams(array $params)
 */
class NoPaper {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取伙伴信息
     *
     * @param  string $code 钉钉返回的Code [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserInfo (string $code) {
        return self::getClass()->getUserInfo([
            "code" => $code,
        ]);
    }

    /**
     * 选择进入的身份类型
     *
     * @param  int $store_id 门店id [ require true ]
     * @param  int $staff_type 摄影师1,化妆师2 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function chooseType (int $store_id, int $staff_type) {
        return self::getClass()->chooseType([
            "store_id" => $store_id,
            "staff_type" => $staff_type,
        ]);
    }

    /**
     * 获取订单无纸化流程伙伴信息
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProcessStaff (int $order_id) {
        return self::getClass()->getProcessStaff([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 获取某个门店所有伙伴
     *
     * @param  int $store_id 门店ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllStaffsByStore (int $store_id) {
        return self::getClass()->getAllStaffsByStore([
            "store_id" => $store_id,
        ]);
    }

    /**
     * 修改伙伴状态
     *
     * @param  string $lastState 之前的状态 [ require true ]
     * @param  string $nowState 现在的状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStatus (string $lastState, string $nowState) {
        return self::getClass()->changeStatus([
            "lastState" => $lastState,
            "nowState" => $nowState,
        ]);
    }

    /**
     * 接单接口 (拿到一条队列数据)
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMessage () {
        return self::getClass()->getMessage();
    }

    /**
     * 获得当前用户的已接订单
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCurrentOrder () {
        return self::getClass()->getCurrentOrder();
    }

    /**
     * 获取订单基础信息
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $need 需要的信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderBaseInfo (int $orderId, string $need) {
        return self::getClass()->getOrderBaseInfo([
            "orderId" => $orderId,
            "need" => $need,
        ]);
    }

    /**
     * 获取化妆备注
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getDresserRemark () {
        return self::getClass()->getDresserRemark();
    }

    /**
     * 伙伴接单
     *
     * @param  int $queueId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function takeOrder (int $queueId) {
        return self::getClass()->takeOrder([
            "queueId" => $queueId,
        ]);
    }

    /**
     * 记录前台工作量
     *
     * @param  int $staffId 员工id [ require true ]
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addReceptionRecord (int $staffId, int $orderId) {
        return self::getClass()->addReceptionRecord([
            "staffId" => $staffId,
            "orderId" => $orderId,
        ]);
    }

    /**
     * 退回当前订单
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function dismissOrder (int $orderId) {
        return self::getClass()->dismissOrder([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取当前门店可接单员工
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchCurrentStoreStaff (int $orderId) {
        return self::getClass()->searchCurrentStoreStaff([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 分配订单给某人(辅助化妆)
     *
     * @param  array $toStaffId 分配给某人 [ require true ]
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function giveOrderToStaff (array $toStaffId, int $orderId) {
        return self::getClass()->giveOrderToStaff([
            "toStaffId" => $toStaffId,
            "orderId" => $orderId,
        ]);
    }

    /**
     * 管理端分配订单给某人
     *
     * @param  int $staffType 用户类型 [ require true ]
     * @param  int $toStaffId 分配给某人 [ require true ]
     * @param  int $orderId 订单id [ require true ]
     * @param  int $queueId 队列id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function giveOrderToStaffInManage (int $staffType, int $toStaffId, int $orderId, int $queueId = 0) {
        return self::getClass()->giveOrderToStaffInManage([
            "staffType" => $staffType,
            "toStaffId" => $toStaffId,
            "orderId" => $orderId,
            "queueId" => $queueId,
        ]);
    }

    /**
     * 摄影师手动再来一单
     *
     * @throws  \Exception
     * @return  string
     */
    public static function orderAgain () {
        return self::getClass()->orderAgain();
    }

    /**
     * 获取门店在当前等待队列队尾序号
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $type 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getLastQueueSort (int $orderId, string $type) {
        return self::getClass()->getLastQueueSort([
            "orderId" => $orderId,
            "type" => $type,
        ]);
    }

    /**
     * 调整订单等待状态和优先级
     *
     * @param  int $queueId 队列id [ require true ]
     * @param  string $type 等待状态类型 [ require true ]
     * @param  int $orderId 订单id [ require true ]
     * @param  int $sort 队列优先级序号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function adjustOrderStatus (int $queueId = 0, string $type = '', int $orderId = 0, int $sort = 0) {
        return self::getClass()->adjustOrderStatus([
            "queueId" => $queueId,
            "type" => $type,
            "orderId" => $orderId,
            "sort" => $sort,
        ]);
    }

    /**
     * 管理端获取员工工作量
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function staffWorkload (string $orderNum) {
        return self::getClass()->staffWorkload([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 云图端结束摄影中状态
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  string $comment 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStateByCloud (string $orderNum, string $comment = '') {
        return self::getClass()->changeStateByCloud([
            "orderNum" => $orderNum,
            "comment" => $comment,
        ]);
    }

    /**
     * 修改在线订单备注
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $note 备注 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function modifyOrderNote (int $orderId, string $note) {
        return self::getClass()->modifyOrderNote([
            "orderId" => $orderId,
            "note" => $note,
        ]);
    }

    /**
     * 完成订单
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  string $comment 备注 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function completeOrder (int $orderId, string $comment = '') {
        return self::getClass()->completeOrder([
            "orderId" => $orderId,
            "comment" => $comment,
        ]);
    }

    /**
     * 获取上一个化妆师id
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOriginStaffId (int $orderId) {
        return self::getClass()->getOriginStaffId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 订单退回到原化妆师
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function returnToMakeUp (int $orderId) {
        return self::getClass()->returnToMakeUp([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取用户状态
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getStaffState () {
        return self::getClass()->getStaffState();
    }

    /**
     * 获取在线订单状态数量
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getOnlineOrderCount () {
        return self::getClass()->getOnlineOrderCount();
    }

    /**
     * 获取当日订单列表
     *
     * @param  string $mobile 手机号 [ require true ]
     * @param  string $state 订单状态 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getNowOrderList (string $mobile = '', string $state = '') {
        return self::getClass()->getNowOrderList([
            "mobile" => $mobile,
            "state" => $state,
        ]);
    }

    /**
     * 发送接单提醒
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $staffId 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendTakeOrderNotice (int $orderId, int $staffId) {
        return self::getClass()->sendTakeOrderNotice([
            "orderId" => $orderId,
            "staffId" => $staffId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Order\NoPaper');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Order\NoPaper');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}