<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method setProtocolVersionByParams(array $params)
 * @method registerByParams(array $params)
 * @method feedbackByParams(array $params)
 * @method editBirthByParams(array $params)
 * @method photosByParams(array $params)
 * @method alertCheckByParams(array $params)
 * @method cardCreateByParams(array $params)
 * @method getCouponByParams(array $params)
 * @method activeVipByParams(array $params)
 * @method joinVipByParams(array $params)
 * @method bindEmailByParams(array $params)
 * @method sendCouponByParams(array $params)
 * @method checkSignByParams(array $params)
 * @method refundNoticeByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 记录预约协议版本
     *
     * @support  int $protocol_version 预约协议版本 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setProtocolVersion () {
        return self::getClass()->setProtocolVersion();
    }

    /**
     * 注册
     *
     * @support  int $protocol_version 预约协议版本 [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @support  string $captcha 验证码 [ require true ]
     * @support  string $password 密码 [ require true ]
     * @support  string $name 用户昵称 
     * @support  string $head_img 微信头像 
     * @support  string $sex 用户性别 
     * @support  int $channel 渠道号 
     * @throws  \Exception
     * @return  mixed
     */
    public static function register () {
        return self::getClass()->register();
    }

    /**
     * 用户意见反馈
     *
     * @support  string $content 内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function feedback () {
        return self::getClass()->feedback();
    }

    /**
     * 修改用户信息
     *
     * @support  string $name 用户昵称 
     * @support  string $birth 用户生日 
     * @support  string $sex 用户性别 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editBirth () {
        return self::getClass()->editBirth();
    }

    /**
     * 获取用户所有的照片
     *
     * @support  int $page 页数 
     * @support  int $page_size 每页显示月数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function photos () {
        return self::getClass()->photos();
    }

    /**
     * 用户vip升级弹框标记
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function alertCheck () {
        return self::getClass()->alertCheck();
    }

    /**
     * 生成微信会员卡
     *
     * @support  string $scene 用户id [ require true ]
     * @support  string $code code 
     * @support  string $open_id 用户open_id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function cardCreate () {
        return self::getClass()->cardCreate();
    }

    /**
     * 用户vip升级领取优惠券hook
     *
     * @support  int $user_id 用户id 
     * @support  string $change 升降级类型 
     * @support  string $origin_level 原等级 
     * @support  string $current_level 当前等级 
     * @support  bool $is_review 是否为复审 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCoupon () {
        return self::getClass()->getCoupon();
    }

    /**
     * 用户激活会员
     *
     * @support  int $user_id 用户id 
     * @support  string $current_level 当前等级 
     * @throws  \Exception
     * @return  mixed
     */
    public static function activeVip () {
        return self::getClass()->activeVip();
    }

    /**
     * 加入会员
     *
     * @support  int $user_id 用户id 
     * @support  string $current_level 当前等级 
     * @throws  \Exception
     * @return  mixed
     */
    public static function joinVip () {
        return self::getClass()->joinVip();
    }

    /**
     * 绑定邮箱
     *
     * @support  string $email 邮箱地址 [ require true ]
     * @support  string $code 验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindEmail () {
        return self::getClass()->bindEmail();
    }

    /**
     * 绑定邮箱发放优惠券
     *
     * @param  string $brand 品牌 [ require true ]
     * @param  string $email email [ require true ]
     * @param  int $user_id 用户id [Original type uint] [ require true ]
     * @param  string $choose 选择的券 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendCoupon (string $brand, string $email, int $user_id, string $choose) {
        return self::getClass()->sendCoupon([
            "brand" => $brand,
            "email" => $email,
            "user_id" => $user_id,
            "choose" => $choose,
        ]);
    }

    /**
     * 绑定邮箱校验是否通过验证
     *
     * @param  string $brand 品牌 [ require true ]
     * @param  int $user_id 用户uid [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function checkSign (string $brand, int $user_id) {
        return self::getClass()->checkSign([
            "brand" => $brand,
            "user_id" => $user_id,
        ]);
    }

    /**
     * 退款推送
     *
     * @param  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refundNotice (string $order_no) {
        return self::getClass()->refundNotice([
            "order_no" => $order_no,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}