<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method encodeOrderDetailByParams(array $params)
 * @method cancelByParams(array $params)
 * @method deleteByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method bindByParams(array $params)
 * @method photoByParams(array $params)
 * @method icbcPhotoByParams(array $params)
 * @method refundByParams(array $params)
 * @method refundRealMoneyByParams(array $params)
 * @method refundInfoByParams(array $params)
 * @method orderCompleteByParams(array $params)
 * @method sendKfMessageByParams(array $params)
 * @method paySuccessSendNoticeByParams(array $params)
 * @method reasonByParams(array $params)
 * @method photoTemplatesByParams(array $params)
 * @method esOrderByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @support  string $user_phone 用户手机号 [ require true ]
     * @support  string $user_sex 用户性别 [ require true ]
     * @support  string $user_name 用户姓名 [ require true ]
     * @support  string $user_birthday 用户生日 [ require true ]
     * @support  string $reserve_time 预约时间 [ require true ]
     * @support  array $detail 订单详情(商品&amp;服务详情) [ require true ]
     * @support  float $gift_card_money 礼品卡抵扣金额 [Original type double] 
     * @support  int $coupon_id 优惠券ID 
     * @support  float $coupon_deduction_money 优惠券优惠金额 [Original type unsignedDouble] 
     * @support  int $product_card_id 产品卡ID 
     * @support  float $product_card_deduction_money 产品卡优惠金额 [Original type unsignedDouble] 
     * @support  array $product_discount_ids 组合优惠id 
     * @support  float $product_discount_deduction_money 组合优惠优惠金额 [Original type unsignedDouble] 
     * @support  int $store_id 门店id [ require true ]
     * @support  int $channel 渠道号 
     * @support  string $note 备注 
     * @support  float $ori_money 原始价格 [Original type unsignedDouble] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取订单列表
     *
     * @support  string $status 订单状态-total:全部,wait:待拍摄,today:当日拍摄,complete:已完成,close:已关闭 [ require true ]
     * @support  int $page 页数 
     * @support  int $page_size 每页条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取订单详情
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 获取加密订单详情
     *
     * @param  string $encode_order_num 加密的订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function encodeOrderDetail (string $encode_order_num) {
        return self::getClass()->encodeOrderDetail([
            "encode_order_num" => $encode_order_num,
        ]);
    }

    /**
     * 取消未支付订单
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel () {
        return self::getClass()->cancel();
    }

    /**
     * 删除订单
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 修改预约时间
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  string $reserve_time 新预约时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeReserveTime () {
        return self::getClass()->changeReserveTime();
    }

    /**
     * 绑定订单
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bind () {
        return self::getClass()->bind();
    }

    /**
     * 获取云端原片地址
     *
     * @support  string $order_num 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function photo () {
        return self::getClass()->photo();
    }

    /**
     * icbc真我卡获取云端原片地址
     *
     * @support  int $user_id 用户id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function icbcPhoto () {
        return self::getClass()->icbcPhoto();
    }

    /**
     * 申请退款
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  int $reason_id 退款原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refund () {
        return self::getClass()->refund();
    }

    /**
     * 申请现金退款
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  int $reason_id 退款原因 [ require true ]
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账户 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refundRealMoney () {
        return self::getClass()->refundRealMoney();
    }

    /**
     * 退款信息补全
     *
     * @support  int $refund_id 退款ID [ require true ]
     * @support  string $order_no 订单号 [ require true ]
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账户 [ require true ]
     * @support  array $extend 订单extend 
     * @throws  \Exception
     * @return  array
     */
    public static function refundInfo () {
        return self::getClass()->refundInfo();
    }

    /**
     * 订单完成推送通知
     *
     * @support  int $orderId 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderComplete () {
        return self::getClass()->orderComplete();
    }

    /**
     * 婚礼照推送
     *
     * @support  int $user_id 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendKfMessage () {
        return self::getClass()->sendKfMessage();
    }

    /**
     * 支付成功推送
     *
     * @support  array $wxData 微信发送参数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function paySuccessSendNotice () {
        return self::getClass()->paySuccessSendNotice();
    }

    /**
     * 退款理由
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reason () {
        return self::getClass()->reason();
    }

    /**
     * 获取照片模板
     *
     * @param  array $product_ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function photoTemplates (array $product_ids) {
        return self::getClass()->photoTemplates([
            "product_ids" => $product_ids,
        ]);
    }

    /**
     * 退款理由
     *
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function esOrder () {
        return self::getClass()->esOrder();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}