<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method staffByParams(array $params)
 * @method storeByParams(array $params)
 * @method allByParams(array $params)
 * @method storeNowByParams(array $params)
 * @method allNowByParams(array $params)
 * @method currentFinanceFluentByParams(array $params)
 * @method newCurrentFinanceFluentByParams(array $params)
 */
class PerformanceCollect {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 个人绩效统计
     *
     * @support  string $start_time 查询的开始时间 [ require true ]
     * @support  string $stop_time 查询的结束时间 [ require true ]
     * @support  int $staff_id 个人id [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function staff () {
        return self::getClass()->staff();
    }

    /**
     * 门店绩效统计
     *
     * @support  string $start_time 查询的开始时间 [ require true ]
     * @support  string $stop_time 查询的结束时间 [ require true ]
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function store () {
        return self::getClass()->store();
    }

    /**
     * 总体绩效统计
     *
     * @support  string $start_time 查询的开始时间 [ require true ]
     * @support  string $stop_time 查询的结束时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 门店绩效统计(实时查询)
     *
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function storeNow () {
        return self::getClass()->storeNow();
    }

    /**
     * 总体绩效统计(实时查询)
     *
     * @throws  \Exception
     * @return  array
     */
    public static function allNow () {
        return self::getClass()->allNow();
    }

    /**
     * 实时财务流水
     *
     * @param  string $start_time 查询的开始时间 [ require true ]
     * @param  string $stop_time 查询的结束时间 [ require true ]
     * @param  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function currentFinanceFluent (string $start_time, string $stop_time, int $store_id) {
        return self::getClass()->currentFinanceFluent([
            "start_time" => $start_time,
            "stop_time" => $stop_time,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 新版财务流水，往日取自大数据，今日取自实时计算
     *
     * @param  string $start_time 查询的开始时间 [ require true ]
     * @param  string $stop_time 查询的结束时间 [ require true ]
     * @param  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function newCurrentFinanceFluent (string $start_time, string $stop_time, int $store_id) {
        return self::getClass()->newCurrentFinanceFluent([
            "start_time" => $start_time,
            "stop_time" => $stop_time,
            "store_id" => $store_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\PerformanceCollect');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\PerformanceCollect');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}