<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailByNoByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method itemsByParams(array $params)
 * @method payByParams(array $params)
 */
class OfflineOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建线下订单
     *
     * @support  int $amount  [ require true ]
     * @support  float $money 订单金额 [Original type double] [ require true ]
     * @support  int $income_item_id 线下收入项目ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 线下订单详情
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 线下订单详情【更加订单号】
     *
     * @support  string $order_no 订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByNo () {
        return self::getClass()->detailByNo();
    }

    /**
     * 线下订单列表
     *
     * @support  string $pay_type 支付类型，同子订单支付类型 
     * @support  string $status 状态 
     * @support  string $status_list 状态列表 
     * @support  string $order_no 订单编号 
     * @support  string $paid_at_start 支付时间起始 
     * @support  string $paid_at_end 支付时间结束 
     * @support  int $page  
     * @support  int $page_size  
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 删除线下订单
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 线下产品
     *
     * @throws  \Exception
     * @return  array
     */
    public static function items () {
        return self::getClass()->items();
    }

    /**
     * 线下订单支付
     *
     * @support  int $id 订单id [ require true ]
     * @support  string $pay_type 支付方式 [ require true ]
     * @support  string $payment_no 支付流水号 
     * @throws  \Exception
     * @return  array
     */
    public static function pay () {
        return self::getClass()->pay();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\OfflineOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\OfflineOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}