<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method extractByParams(array $params)
 * @method getProgressByParams(array $params)
 * @method getAllProductByBrandByParams(array $params)
 * @method getTodayEvaluateCountByParams(array $params)
 * @method getExtractListByParams(array $params)
 * @method notDealWithTheItemByParams(array $params)
 * @method changeItemByParams(array $params)
 * @method preCommitScoreByParams(array $params)
 * @method getPreScoreListByParams(array $params)
 * @method confirmByParams(array $params)
 * @method getScoreConfigByParams(array $params)
 * @method updateScoreConfigByParams(array $params)
 * @method queryRecordHistoryByParams(array $params)
 * @method queryQualityReportByParams(array $params)
 * @method getStaffByParams(array $params)
 * @method getStreamInfoByParams(array $params)
 */
class CheckPool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 抽片
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @support  int $newStaffCount 新人伙伴抽样量 
     * @support  int $formalStaffCount 正式伙伴抽样量 
     * @support  array $productArr 产品类型组 
     * @throws  \Exception
     * @return  string
     */
    public static function extract (string $poolType) {
        return self::getClass()->extract([
            "poolType" => $poolType,
        ]);
    }

    /**
     * 获取抽片进度
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProgress () {
        return self::getClass()->getProgress();
    }

    /**
     * 通过品牌获取所有产品
     *
     * @param  string $brand 品牌 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllProductByBrand (string $brand = '') {
        return self::getClass()->getAllProductByBrand([
            "brand" => $brand,
        ]);
    }

    /**
     * 今日已评单量
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTodayEvaluateCount () {
        return self::getClass()->getTodayEvaluateCount();
    }

    /**
     * 获取抽片列表
     *
     * @support  int $page 页码 
     * @support  int $pageSize 每页数量 
     * @throws  \Exception
     * @return  array
     */
    public static function getExtractList () {
        return self::getClass()->getExtractList();
    }

    /**
     * 不处理此项
     *
     * @param  string $itemId 项目id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function notDealWithTheItem (string $itemId) {
        return self::getClass()->notDealWithTheItem([
            "itemId" => $itemId,
        ]);
    }

    /**
     * 换一单
     *
     * @param  string $itemId 项目id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeItem (string $itemId) {
        return self::getClass()->changeItem([
            "itemId" => $itemId,
        ]);
    }

    /**
     * 预评分
     *
     * @param  string $itemId 项目id [ require true ]
     * @param  array $score 评分内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function preCommitScore (string $itemId, array $score) {
        return self::getClass()->preCommitScore([
            "itemId" => $itemId,
            "score" => $score,
        ]);
    }

    /**
     * 获取预评分列表
     *
     * @support  int $page 页码 
     * @support  int $pageSize 每页数量 
     * @throws  \Exception
     * @return  array
     */
    public static function getPreScoreList () {
        return self::getClass()->getPreScoreList();
    }

    /**
     * 最终确认
     *
     * @support  array $batchScore 批量评分 
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirm () {
        return self::getClass()->confirm();
    }

    /**
     * 获取评分配置
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getScoreConfig (string $poolType) {
        return self::getClass()->getScoreConfig([
            "poolType" => $poolType,
        ]);
    }

    /**
     * 评分配置调整
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @param  array $delConfig 删除配置 [ require true ]
     * @param  array $newConfig 新增配置 [ require true ]
     * @param  array $updateConfig 更新配置 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function updateScoreConfig (string $poolType, array $delConfig = [], array $newConfig = [], array $updateConfig = []) {
        return self::getClass()->updateScoreConfig([
            "poolType" => $poolType,
            "delConfig" => $delConfig,
            "newConfig" => $newConfig,
            "updateConfig" => $updateConfig,
        ]);
    }

    /**
     * 查询评分历史记录
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @param  string $startTime 评分开始时间 [ require true ]
     * @param  string $endTime 评分结束时间 [ require true ]
     * @support  int $page 页码 
     * @support  int $pageSize 每页数量 
     * @throws  \Exception
     * @return  array
     */
    public static function queryRecordHistory (string $poolType, string $startTime, string $endTime) {
        return self::getClass()->queryRecordHistory([
            "poolType" => $poolType,
            "startTime" => $startTime,
            "endTime" => $endTime,
        ]);
    }

    /**
     * 查询质量报告
     *
     * @param  string $poolType 抽片池类型 [ require true ]
     * @support  string $startTime 评分开始时间 
     * @support  string $endTime 评分结束时间 
     * @support  array $storeIds 门店ids 
     * @support  array $productIds 产品ids 
     * @support  array $staffIds 伙伴ids 
     * @support  array $supervisorArr 督导ids 
     * @support  array $score 评分内容 
     * @support  array $totalScoreRange 总分区间 
     * @support  int $page 页码 
     * @support  int $pageSize 每页数量 
     * @throws  \Exception
     * @return  array
     */
    public static function queryQualityReport (string $poolType) {
        return self::getClass()->queryQualityReport([
            "poolType" => $poolType,
        ]);
    }

    /**
     * 获取伙伴
     *
     * @param  string $staffEntryType 伙伴入职类型 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaff (string $staffEntryType = '') {
        return self::getClass()->getStaff([
            "staffEntryType" => $staffEntryType,
        ]);
    }

    /**
     * 获取流水信息
     *
     * @param  int $cloudStreamId 流水id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStreamInfo (int $cloudStreamId) {
        return self::getClass()->getStreamInfo([
            "cloudStreamId" => $cloudStreamId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\CheckPool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\CheckPool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}