<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method storeStaffByParams(array $params)
 * @method staffPluralismConfirmByParams(array $params)
 * @method staffPluralismStopByParams(array $params)
 * @method getTechnologistListByParams(array $params)
 * @method getSupervisorListByParams(array $params)
 * @method assignSupervisorByParams(array $params)
 * @method getSupervisorByTechnologistByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取员工列表
     *
     * @param  int $store_id 门店id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $store_id) {
        return self::getClass()->list([
            "store_id" => $store_id,
        ]);
    }

    /**
     * 根据分类获取门店成员列表
     *
     * @support  int $store_id 门店ID 
     * @support  string $staff_type 伙伴职位Alias 
     * @throws  \Exception
     * @return  array
     */
    public static function storeStaff () {
        return self::getClass()->storeStaff();
    }

    /**
     * 兼岗确认添加对应门店权限
     *
     * @param  int $pluralism_store_id 门店ID [ require true ]
     * @param  int $staff_id 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function staffPluralismConfirm (int $pluralism_store_id, int $staff_id) {
        return self::getClass()->staffPluralismConfirm([
            "pluralism_store_id" => $pluralism_store_id,
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 兼岗确认添加对应门店权限
     *
     * @param  int $pluralism_store_id 门店ID [ require true ]
     * @param  int $staff_id 伙伴id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function staffPluralismStop (int $pluralism_store_id, int $staff_id) {
        return self::getClass()->staffPluralismStop([
            "pluralism_store_id" => $pluralism_store_id,
            "staff_id" => $staff_id,
        ]);
    }

    /**
     * 获取技术专家列表
     *
     * @support  string $name 伙伴姓名 
     * @support  string $nick_name 伙伴昵称 
     * @throws  \Exception
     * @return  array
     */
    public static function getTechnologistList () {
        return self::getClass()->getTechnologistList();
    }

    /**
     * 获取督导列表
     *
     * @support  string $name 伙伴姓名 
     * @support  string $nick_name 伙伴昵称 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSupervisorList () {
        return self::getClass()->getSupervisorList();
    }

    /**
     * 技术专家关联督导
     *
     * @support  int $technologist_id 技术专家id [ require true ]
     * @support  array $supervisor_ids 督导ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function assignSupervisor () {
        return self::getClass()->assignSupervisor();
    }

    /**
     * 通过技术专家获取督导
     *
     * @support  int $technologist_id 技术专家id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSupervisorByTechnologist () {
        return self::getClass()->getSupervisorByTechnologist();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}