<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method addStoreDiscountByParams(array $params)
 * @method getDiscountListByParams(array $params)
 * @method editDiscountByParams(array $params)
 * @method deleteDiscountByParams(array $params)
 * @method getStoreDiscountByParams(array $params)
 */
class ProductDiscount {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店折扣详情
     *
     * @support  int $store_id 门店ID [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 如果创建的是单品折扣, 请使用新建单品折扣规则接口
     *
     * @support  string $name 折扣名称 [ require true ]
     * @support  string $group 折扣分组 [ require true ]
     * @support  int $sort 折扣顺序, 折扣时将从最大的开始匹配 [Original type uint] 
     * @support  int $sc_id 门店分类ID, 用于筛选门店 [Original type uint] [ require true ]
     * @support  string $discount_type 折扣类型 [ require true ]
     * @support  string $share_type 共享类型 [ require true ]
     * @support  string $payload_check 折扣规则校验 [ require true ]
     * @support  array $payload_product_array 折扣适用产品 
     * @support  int $mini_kind_num 最小产品种类 [Original type uint] 
     * @support  int $mini_product_num 最小产品数量 [Original type uint] 
     * @support  int $mini_buy_price 最小购买金额 [Original type uint] 
     * @support  int $mini_service_num 最小选取服务数量 [Original type uint] 
     * @support  string $discount_payload_type 折扣适配类型 
     * @support  float $product_discount_calc 产品立减值/折扣值 [Original type double] 
     * @support  float $service_discount_calc 服务立减值/折扣值 [Original type double] 
     * @support  int $is_limit 是否为限时折扣 [Original type uint] 
     * @support  string $start_time 折扣开始时间 
     * @support  string $end_time 折扣结束时间 
     * @support  array $payload 折扣计算载荷 
     * @support  array $show_info 前端显示信息 
     * @throws  \Exception
     * @return  array
     */
    public static function addStoreDiscount () {
        return self::getClass()->addStoreDiscount();
    }

    /**
     * 折扣列表
     *
     * @support  string $group 折扣分组 [ require true ]
     * @support  int $page 当前页 
     * @support  int $page_size 页内条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDiscountList () {
        return self::getClass()->getDiscountList();
    }

    /**
     * 修改折扣信息
     *
     * @support  int $discount_id 编辑的ID [Original type uint] [ require true ]
     * @support  array $show_info 前端显示信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editDiscount () {
        return self::getClass()->editDiscount();
    }

    /**
     * 删除折扣
     *
     * @support  int $discount_id 折扣id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteDiscount () {
        return self::getClass()->deleteDiscount();
    }

    /**
     * 获取的折扣可能包含一个小时内将会开始, 但是当前暂未开始的活动, 需要前端注意判断
     *
     * @support  int $store_id 门店ID [Original type uint] [ require true ]
     * @support  bool $add_hour 是否包含一个小时内将会开始的活动 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreDiscount () {
        return self::getClass()->getStoreDiscount();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductDiscount');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductDiscount');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}