<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method createByParams(array $params)
 * @method bindUserByParams(array $params)
 * @method unbindUserByParams(array $params)
 * @method submitByParams(array $params)
 * @method cancelByParams(array $params)
 * @method paidByParams(array $params)
 * @method startByParams(array $params)
 * @method finishByParams(array $params)
 * @method recoverWaitShootingByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method changeUserDataByParams(array $params)
 * @method changeStoreByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单列表查询
     *
     * @support  array $order_ids 订单编号s 
     * @support  array $order_nos 订单ids 
     * @support  array $store_ids 门店ids 
     * @support  string $reserve_time_start 预约开始时间 
     * @support  string $reserve_time_end 预约结束时间 
     * @support  string $create_time_start 查询开始时间 
     * @support  string $create_time_end 查询结束时间 
     * @support  array $user_ids 绑定用户uids 
     * @support  array $status 订单状态s 
     * @support  string $user_name 下单用户 
     * @support  array $user_phone 手机号 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @support  string $sort_field 排序字段 
     * @support  bool $sort_desc 是否倒序 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取订单详情
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 创建订单（管理端开单）
     *
     * @support  int $user_id 用户ID 
     * @support  string $user_phone 用户手机号 [ require true ]
     * @support  string $reserve_time 预约时间 [ require true ]
     * @support  int $occupy_num 排单表占点数量 [ require true ]
     * @support  array $detail 订单详情（商品&amp;服务详情） [ require true ]
     * @support  float $gift_card_money 礼品卡抵扣金额 [Original type double] 
     * @support  int $coupon_id 优惠券ID 
     * @support  int $product_card_id 产品卡ID 
     * @support  string $interior_coupon_code 开单折扣码 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 绑定用户
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $user_id 用户ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function bindUser (int $id, int $user_id) {
        return self::getClass()->bindUser([
            "id" => $id,
            "user_id" => $user_id,
        ]);
    }

    /**
     * 取消绑定用户
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function unbindUser (int $id) {
        return self::getClass()->unbindUser([
            "id" => $id,
        ]);
    }

    /**
     * 提交订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function submit (int $id) {
        return self::getClass()->submit([
            "id" => $id,
        ]);
    }

    /**
     * 取消订单
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reason 取消原因 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cancel (int $id, string $reason) {
        return self::getClass()->cancel([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 完成支付
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $pay_type 支付类型 [ require true ]
     * @param  string $payment_no 支付流水号【管理端非必填】 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function paid (int $id, string $pay_type, string $payment_no) {
        return self::getClass()->paid([
            "id" => $id,
            "pay_type" => $pay_type,
            "payment_no" => $payment_no,
        ]);
    }

    /**
     * 开始订单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function start (int $id) {
        return self::getClass()->start([
            "id" => $id,
        ]);
    }

    /**
     * 完成订单（拍摄完成）
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function finish (int $id) {
        return self::getClass()->finish([
            "id" => $id,
        ]);
    }

    /**
     * 恢复到等待拍摄
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function recoverWaitShooting (int $id) {
        return self::getClass()->recoverWaitShooting([
            "id" => $id,
        ]);
    }

    /**
     * 修改预约时间
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $reserve_time 预约时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeReserveTime (int $id, string $reserve_time) {
        return self::getClass()->changeReserveTime([
            "id" => $id,
            "reserve_time" => $reserve_time,
        ]);
    }

    /**
     * 修改用户数据
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $user_name 用户姓名 [ require true ]
     * @param  string $user_phone 用户手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserData (int $id, string $user_name, string $user_phone) {
        return self::getClass()->changeUserData([
            "id" => $id,
            "user_name" => $user_name,
            "user_phone" => $user_phone,
        ]);
    }

    /**
     * 转门店
     *
     * @param  int $id 订单ID [ require true ]
     * @param  int $store_id 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function changeStore (int $id, int $store_id) {
        return self::getClass()->changeStore([
            "id" => $id,
            "store_id" => $store_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}