<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method openCloseByParams(array $params)
 * @method batchCloseByParams(array $params)
 * @method closeListByParams(array $params)
 * @method closeDeleteByParams(array $params)
 * @method getReserveListByParams(array $params)
 * @method reserveOccupyByParams(array $params)
 */
class Reservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 排单表
     *
     * @param  string $date_start 开始日期 [ require true ]
     * @param  string $date_end 截止日期 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (string $date_start, string $date_end) {
        return self::getClass()->list([
            "date_start" => $date_start,
            "date_end" => $date_end,
        ]);
    }

    /**
     * 关闭/开放时间节点
     *
     * @param  string $order_time 节点时间 [ require true ]
     * @param  string $state 新状态(exit[关闭]|cano[打开]) [ require true ]
     * @param  int $index 节点index [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function openClose (string $order_time, string $state, int $index) {
        return self::getClass()->openClose([
            "order_time" => $order_time,
            "state" => $state,
            "index" => $index,
        ]);
    }

    /**
     * 批量关闭时间节点
     *
     * @param  int $each_time_unset 关闭时间节点的位置数 [ require true ]
     * @param  string $date_begin 开始日期 [ require true ]
     * @param  string $date_end 结束日期 [ require true ]
     * @param  string $time_begin 开始时间 [ require true ]
     * @param  string $time_end 结束时间 [ require true ]
     * @param  bool $all_success 是否不允许部分失败 [ require true ]
     * @support  bool $is_repeat 是否按日重复关闭 
     * @support  string $reason 原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchClose (int $each_time_unset, string $date_begin, string $date_end, string $time_begin, string $time_end, bool $all_success = false) {
        return self::getClass()->batchClose([
            "each_time_unset" => $each_time_unset,
            "date_begin" => $date_begin,
            "date_end" => $date_end,
            "time_begin" => $time_begin,
            "time_end" => $time_end,
            "all_success" => $all_success,
        ]);
    }

    /**
     * 关闭/开放时间节点记录
     *
     * @support  int $page 分页 
     * @support  int $page_size 每页数据条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeList () {
        return self::getClass()->closeList();
    }

    /**
     * 删除关闭记录
     *
     * @param  string $id 关闭记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeDelete (string $id) {
        return self::getClass()->closeDelete([
            "id" => $id,
        ]);
    }

    /**
     * 管理端获取可改约的时间
     *
     * @param  int $store_id 门店ID [ require true ]
     * @param  string $date_start 开始日期 [ require true ]
     * @param  string $date_end 结束日期 [ require true ]
     * @param  array $product_group 产品数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getReserveList (int $store_id, string $date_start, string $date_end, array $product_group) {
        return self::getClass()->getReserveList([
            "store_id" => $store_id,
            "date_start" => $date_start,
            "date_end" => $date_end,
            "product_group" => $product_group,
        ]);
    }

    /**
     * 排单表占点
     *
     * @param  string $date_start 开始日期 [ require true ]
     * @param  string $date_end 结束日期 [ require true ]
     * @param  array $product_group 产品数组 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function reserveOccupy (string $date_start, string $date_end, array $product_group) {
        return self::getClass()->reserveOccupy([
            "date_start" => $date_start,
            "date_end" => $date_end,
            "product_group" => $product_group,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Reservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Reservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}