<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getProductPriceStoreByParams(array $params)
 * @method detailByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getPriceByProductIdByParams(array $params)
 */
class ProductPrice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品价格
     *
     * @support  int $product_id 产品id [ require true ]
     * @support  float $original_price 原价 [Original type double] [ require true ]
     * @support  float $price 现价 [Original type double] [ require true ]
     * @support  float $add_people_price 加人加价 [Original type double] 
     * @support  string $price_mode 价格类型 
     * @support  string $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取产品价格绑定门店
     *
     * @support  int $price_id price_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductPriceStore () {
        return self::getClass()->getProductPriceStore();
    }

    /**
     * 产品价格详情
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 更新产品价格
     *
     * @support  int $id id [ require true ]
     * @support  int $product_id 产品id [ require true ]
     * @support  float $original_price 原价 [Original type double] [ require true ]
     * @support  float $price 现价 [Original type double] [ require true ]
     * @support  float $add_people_price 加人加价 [Original type double] 
     * @support  string $price_mode 价格类型 
     * @support  string $extend 拓展信息 
     * @throws  \Exception
     * @return  array
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 删除产品价格
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 获取产品所有价格
     *
     * @support  int $product_id 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPriceByProductId () {
        return self::getClass()->getPriceByProductId();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductPrice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductPrice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}