<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method indexByParams(array $params)
 * @method detailByParams(array $params)
 * @method batchDetailByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店产品列表
     *
     * @support  int $storeId 门店ID [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function index () {
        return self::getClass()->index();
    }

    /**
     * 获取产品详情
     *
     * @param  int $product_id 产品ID [ require true ]
     * @param  int $store_id 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $product_id, int $store_id) {
        return self::getClass()->detail([
            "product_id" => $product_id,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 批量获取多个产品详情
     *
     * @param  array $product_ids 产品ID [ require true ]
     * @param  int $store_id 门店ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchDetail (array $product_ids, int $store_id) {
        return self::getClass()->batchDetail([
            "product_ids" => $product_ids,
            "store_id" => $store_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}