<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createGroupByParams(array $params)
 * @method createItemByParams(array $params)
 * @method getItemByGroupIdByParams(array $params)
 * @method groupDetailByParams(array $params)
 * @method itemDetailByParams(array $params)
 * @method removeGroupByParams(array $params)
 * @method removeItemByParams(array $params)
 * @method updateGroupByParams(array $params)
 * @method updateItemByParams(array $params)
 * @method getStyleByProductIdByParams(array $params)
 */
class ProductStyle {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建风格组
     *
     * @support  string $name 产品风格组名称 [ require true ]
     * @support  int $product_id 产品id [ require true ]
     * @support  int $parent_id 产品id 
     * @support  string $eng_name 英文名称 
     * @support  int $sort 排序 
     * @throws  \Exception
     * @return  array
     */
    public static function createGroup () {
        return self::getClass()->createGroup();
    }

    /**
     * 创建风格
     *
     * @support  string $name 产品风格名称 [ require true ]
     * @support  int $group_id 父级id 
     * @support  string $eng_name 英文名称 
     * @support  int $sort 排序 
     * @throws  \Exception
     * @return  array
     */
    public static function createItem () {
        return self::getClass()->createItem();
    }

    /**
     * 获取当前风格组下所有风格
     *
     * @support  int $group_id 风格组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getItemByGroupId () {
        return self::getClass()->getItemByGroupId();
    }

    /**
     * 风格组详情
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function groupDetail () {
        return self::getClass()->groupDetail();
    }

    /**
     * 风格详情
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function itemDetail () {
        return self::getClass()->itemDetail();
    }

    /**
     * 删除风格组
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeGroup () {
        return self::getClass()->removeGroup();
    }

    /**
     * 删除风格
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeItem () {
        return self::getClass()->removeItem();
    }

    /**
     * 更新风格组
     *
     * @support  int $id id [ require true ]
     * @support  string $name 产品风格组名称 [ require true ]
     * @support  int $parent_id 父级id 
     * @support  int $product_id 产品id 
     * @support  string $eng_name 英文名称 
     * @support  int $sort 排序 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateGroup () {
        return self::getClass()->updateGroup();
    }

    /**
     * 更新风格
     *
     * @support  int $id id [ require true ]
     * @support  string $name 风格名称 [ require true ]
     * @support  int $group_id 父级id 
     * @support  string $eng_name 英文名称 
     * @support  int $sort 排序 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateItem () {
        return self::getClass()->updateItem();
    }

    /**
     * 获取风格
     *
     * @support  int $product_id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStyleByProductId () {
        return self::getClass()->getStyleByProductId();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductStyle');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductStyle');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}