<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createGroupByParams(array $params)
 * @method getGroupDetailByParams(array $params)
 * @method getListByParams(array $params)
 * @method removeGroupByParams(array $params)
 * @method updateGroupByParams(array $params)
 * @method createItemByParams(array $params)
 * @method itemDetailByParams(array $params)
 * @method removeItemByParams(array $params)
 * @method updateItemByParams(array $params)
 * @method getItemByGroupIdByParams(array $params)
 */
class ProductService {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建升级服务组
     *
     * @support  string $name 升级服务组名称 [ require true ]
     * @support  int $parent_id 父级id 
     * @throws  \Exception
     * @return  array
     */
    public static function createGroup () {
        return self::getClass()->createGroup();
    }

    /**
     * 升级服务组详情
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGroupDetail () {
        return self::getClass()->getGroupDetail();
    }

    /**
     * 升级服务组列表
     *
     * @support  int $page 当前页 
     * @support  int $page_size 页内条数 
     * @support  string $name 升级服务组名称(支持模糊搜索) 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 删除升级服务组
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeGroup () {
        return self::getClass()->removeGroup();
    }

    /**
     * 更新升级服务组
     *
     * @support  int $id id [ require true ]
     * @support  string $name 升级服务组名称 [ require true ]
     * @support  int $parent_id 父级id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateGroup () {
        return self::getClass()->updateGroup();
    }

    /**
     * 创建升级服务
     *
     * @support  string $name 类目名称 [ require true ]
     * @support  int $group_id 父级id 
     * @throws  \Exception
     * @return  array
     */
    public static function createItem () {
        return self::getClass()->createItem();
    }

    /**
     * 升级服务详情
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function itemDetail () {
        return self::getClass()->itemDetail();
    }

    /**
     * 删除升级服务
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeItem () {
        return self::getClass()->removeItem();
    }

    /**
     * 更新升级服务
     *
     * @support  int $id id [ require true ]
     * @support  string $name 类目名称 [ require true ]
     * @support  int $group_id 父级id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateItem () {
        return self::getClass()->updateItem();
    }

    /**
     * 获取当前升级服务组下所有升级服务
     *
     * @support  int $group_id 服务组id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getItemByGroupId () {
        return self::getClass()->getItemByGroupId();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductService');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductService');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}