<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchCreateByParams(array $params)
 * @method allByParams(array $params)
 * @method listByParams(array $params)
 * @method priceByParams(array $params)
 */
class InteriorPreferential {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 生成开单折扣码
     *
     * @support  string $remark 备注 
     * @support  int $count 创建数量 [Original type uint] [ require true ]
     * @support  float $per_money 单个金额 [Original type double] [ require true ]
     * @support  array $extend 拓展信息 
     * @support  string $stop_usage 过期时间 [ require true ]
     * @support  int $store_id 门店id [Original type uint] 
     * @support  float $pay_money 实际支付 [Original type double] 
     * @support  string $buy_channel 售卖渠道 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate () {
        return self::getClass()->batchCreate();
    }

    /**
     * 获取开单折扣码列表(所有)
     *
     * @param  int $create_log_id 记录id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (int $create_log_id) {
        return self::getClass()->all([
            "create_log_id" => $create_log_id,
        ]);
    }

    /**
     * 获取开单折扣码列表(分页)
     *
     * @support  int $create_log_id 记录id 
     * @support  int $page 页码 
     * @support  int $page_size 每页显示数量 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取优惠码价格
     *
     * @param  string $code 优惠码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function price (string $code) {
        return self::getClass()->price([
            "code" => $code,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\InteriorPreferential');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\InteriorPreferential');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}