<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method getProductByStoreIdByParams(array $params)
 * @method getStoreByPriceIdByParams(array $params)
 * @method getPriceByProductIdByParams(array $params)
 * @method getStoreByProductIdByParams(array $params)
 */
class StoreProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建门店-产品关联/绑定价格到多家门店
     *
     * @support  int $product_price_id 价格ID [Original type uint] [ require true ]
     * @support  array $store_ids 门店ID [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 门店产品关联详情
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 一旦某家门店没有某个产品, 该产品将在此家门店不可售卖
     *
     * @support  int $price_id 价格ID [Original type uint] [ require true ]
     * @support  array $store_ids 门店ID [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove () {
        return self::getClass()->remove();
    }

    /**
     * 获取当前门店拥有的所有产品
     *
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductByStoreId () {
        return self::getClass()->getProductByStoreId();
    }

    /**
     * 获取绑定当前产品价格的所有门店
     *
     * @support  int $price_id 价格ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreByPriceId () {
        return self::getClass()->getStoreByPriceId();
    }

    /**
     * 获取产品价格门店信息
     *
     * @support  int $product_id 产品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPriceByProductId () {
        return self::getClass()->getPriceByProductId();
    }

    /**
     * 获取拥有当前产品的所有门店
     *
     * @support  int $product_id 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreByProductId () {
        return self::getClass()->getStoreByProductId();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\StoreProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\StoreProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}