<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 */
class GiftCardCover {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建礼品卡卡面
     *
     * @support  string $title 卡面标题 [ require true ]
     * @support  string $img_path 卡面图片地址 [ require true ]
     * @support  int $sequence 排序值 [Original type uint] 
     * @support  int $topic_id 主题id [Original type uint] [ require true ]
     * @support  bool $is_on_sale 是否在售 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新礼品卡卡面
     *
     * @support  int $id id [Original type uint] [ require true ]
     * @support  string $title 卡面标题 
     * @support  string $img_path 卡面图片地址 
     * @support  int $sequence 排序值 [Original type uint] 
     * @support  int $topic_id 主题id [Original type uint] 
     * @support  bool $is_on_sale 是否在售 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 获取单个礼品卡卡面信息
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 获取礼品卡卡面列表(分页)
     *
     * @support  int $topic_id 主题ids [Original type uint] 
     * @support  string $title 卡面标题 
     * @support  bool $has_topic_info 是否包含主题信息 
     * @support  bool $is_on_sale 是否在售 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页条数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取礼品卡卡面列表(全部)
     *
     * @support  int $topic_id 主题ids [Original type uint] 
     * @support  string $title 卡面标题 
     * @support  bool $has_topic_info 是否包含主题信息 
     * @support  bool $is_on_sale 是否在售 
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\GiftCardCover');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\GiftCardCover');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}