<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method deleteByParams(array $params)
 * @method updateByParams(array $params)
 * @method getCategoryChildByParams(array $params)
 * @method getProductCategoryListByParams(array $params)
 * @method editExtendByParams(array $params)
 */
class Category {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建类目
     *
     * @support  string $name 类目名称 [ require true ]
     * @support  int $parent_id 父级id [Original type uint] 
     * @support  string $eng_name 英文名称 
     * @support  int $sort 排序 
     * @support  string $host 图片资源站域名 
     * @support  array $service_item_set 详情页-服务项说明 
     * @support  array $samples 详情页样片 
     * @support  array $explan 产品选型弹层-产品说明 
     * @support  array $img_for_service 服务体验展示 
     * @support  bool $multiple 服务体验展示 
     * @support  array $extend 其他配图 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 产品类目详情
     *
     * @support  int $id 类目id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 删除产品类目
     *
     * @support  int $id 类目id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 更新类目
     *
     * @support  int $id id [ require true ]
     * @support  string $name 类目名称 
     * @support  int $parent_id 父级id 
     * @support  string $eng_name 英文名称 
     * @support  int $sort 排序 
     * @support  string $host 图片资源站域名 
     * @support  array $service_item_set 详情页-服务项说明 
     * @support  array $samples 详情页样片 
     * @support  array $explanation 产品选型弹层-产品说明 
     * @support  array $img_for_service 服务体验展示 
     * @support  array $extend 其他配图 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 获取类目所有子集
     *
     * @support  int $id 类目id [Original type uint] [ require true ]
     * @support  string $type 获取方式,树状tree/扁平flat [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCategoryChild () {
        return self::getClass()->getCategoryChild();
    }

    /**
     * 类目列表
     *
     * @support  int $page 当前页 
     * @support  int $page_size 页内条数 
     * @support  string $name 类目名称(支持模糊搜索) 
     * @support  int $parent_id 类目父类id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductCategoryList () {
        return self::getClass()->getProductCategoryList();
    }

    /**
     * 修改extend
     *
     * @support  int $id 类目id 
     * @support  array $extend 额外信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editExtend () {
        return self::getClass()->editExtend();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Category');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Category');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}