<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allByParams(array $params)
 * @method photoDetailByParams(array $params)
 * @method operationPhotoByParams(array $params)
 */
class GuestPhotoPool {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * all
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 客片池详情
     *
     * @support  int $photoId 照片id [ require true ]
     * @support  string $streamNum 流水号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function photoDetail () {
        return self::getClass()->photoDetail();
    }

    /**
     * 点赞/点踩
     *
     * @support  int $photoId 照片id [ require true ]
     * @support  string $streamNum 流水号 [ require true ]
     * @support  string $operationType 操作类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function operationPhoto () {
        return self::getClass()->operationPhoto();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\GuestPhotoPool');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\GuestPhotoPool');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}