<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method logsByParams(array $params)
 * @method qrcodeByParams(array $params)
 */
class Channel {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增渠道
     *
     * @param  string $name 渠道名称 [ require true ]
     * @param  int $channel_num 渠道号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function add (string $name, int $channel_num) {
        return self::getClass()->add([
            "name" => $name,
            "channel_num" => $channel_num,
        ]);
    }

    /**
     * 更新渠道信息
     *
     * @param  int $id 渠道id [ require true ]
     * @param  string $name 渠道名称 [ require true ]
     * @param  int $channel_num 渠道号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id, int $channel_num = 0, string $name = '') {
        return self::getClass()->update([
            "id" => $id,
            "channel_num" => $channel_num,
            "name" => $name,
        ]);
    }

    /**
     * 渠道号列表
     *
     * @support  string $name 渠道名称 
     * @support  int $channelNum 渠道号 
     * @support  int $page 页码 [Original type uint] 
     * @support  int $page_size 每页条数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 删除渠道
     *
     * @param  int $id 渠道id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 获取渠道日志
     *
     * @support  int $id 渠道id [ require true ]
     * @support  bool $from_subscribe 来自新注册用户 
     * @throws  \Exception
     * @return  array
     */
    public static function logs () {
        return self::getClass()->logs();
    }

    /**
     * 获取渠道二维码
     *
     * @param  int $id 渠道id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function qrcode (int $id) {
        return self::getClass()->qrcode([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Channel');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Channel');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}