<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allByParams(array $params)
 * @method detailByParams(array $params)
 * @method productSalesByParams(array $params)
 */
class ProductStore {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店产品列表
     *
     * @support  string $nodeType 节点类型 
     * @support  int $showLevel 显示等级 [Original type uint] 
     * @support  bool $includeHidden 包含隐藏节点 
     * @support  bool $includeDelete 包含下线节点 
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 获取产品详情
     *
     * @support  int $nodeId 产品ID [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 获取产品详情
     *
     * @support  int $nodeId 产品ID [Original type uint] 
     * @support  string $start_time 开始时间 
     * @support  string $end_time 结束时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function productSales () {
        return self::getClass()->productSales();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductStore');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductStore');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}