<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailByIdsByParams(array $params)
 * @method upProductByParams(array $params)
 * @method downProductByParams(array $params)
 * @method removeByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 */
class RetailProduct {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建零售产品
     *
     * @support  string $name 产品名称 [ require true ]
     * @support  int $category_id 产品品类ID [Original type uint] [ require true ]
     * @support  string $main_img 产品主图地址 [ require true ]
     * @support  array $sku_basic 产品规格 [ require true ]
     * @support  array $sku 规格详情 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 编辑零售产品
     *
     * @support  int $id 产品ID [Original type uint] [ require true ]
     * @support  string $name 产品名称 [ require true ]
     * @support  int $category_id 产品品类ID [Original type uint] [ require true ]
     * @support  string $main_img 产品主图地址 [ require true ]
     * @support  array $sku_basic 产品规格 [ require true ]
     * @support  array $sku 规格详情 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 产品详情
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 批量产品详情
     *
     * @param  array $ids 产品ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailByIds (array $ids) {
        return self::getClass()->detailByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * 上架产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upProduct (int $id) {
        return self::getClass()->upProduct([
            "id" => $id,
        ]);
    }

    /**
     * 下架产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function downProduct (int $id) {
        return self::getClass()->downProduct([
            "id" => $id,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id 产品ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove (int $id) {
        return self::getClass()->remove([
            "id" => $id,
        ]);
    }

    /**
     * 产品分页列表
     *
     * @support  int $page 当前页 
     * @support  int $page_size 页内条数 
     * @support  string $name 名称(模糊查询) 
     * @support  int $category_id 品类ID [Original type uint] 
     * @support  string $status 产品状态 
     * @support  bool $show_deleted 是否显示已删除信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 产品分页列表
     *
     * @support  string $name 名称(模糊查询) 
     * @support  int $category_id 品类ID [Original type uint] 
     * @support  string $status 产品状态 
     * @support  bool $show_deleted 是否显示已删除信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\RetailProduct');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\RetailProduct');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}