<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method deleteByParams(array $params)
 * @method updateByParams(array $params)
 * @method getProductListByParams(array $params)
 * @method upProductByParams(array $params)
 * @method downProductByParams(array $params)
 * @method styleGroupsByParams(array $params)
 * @method styleLabelsByParams(array $params)
 * @method serviceGroupsByParams(array $params)
 * @method serviceLabelsByParams(array $params)
 * @method addStyleGroupByParams(array $params)
 * @method addStyleLabelByParams(array $params)
 * @method addServiceGroupByParams(array $params)
 * @method addServiceLabelByParams(array $params)
 * @method productPriceListByProductByParams(array $params)
 * @method servicePriceListByServiceByParams(array $params)
 * @method createProductPriceByParams(array $params)
 * @method updateProductPriceByParams(array $params)
 * @method deleteProductPriceByParams(array $params)
 * @method bindProductToStoresByParams(array $params)
 * @method createServicePriceByParams(array $params)
 * @method updateServicePriceByParams(array $params)
 * @method deleteServicePriceByParams(array $params)
 * @method bindServiceToStoresByParams(array $params)
 * @method infoByParams(array $params)
 * @method batchDetailByParams(array $params)
 * @method storeProductByParams(array $params)
 * @method productDiscountCalcByParams(array $params)
 * @method editExtendByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @support  string $name 产品名称 [ require true ]
     * @support  int $category_id 产品所属类目id [ require true ]
     * @support  string $main_img 主图 
     * @support  string $description 描述 
     * @support  string $eng_name 英文名称 
     * @support  int $mini_people_num 最小人数 
     * @support  int $max_people_num 最大人数 
     * @support  int $sort 排序 
     * @support  array $styles 风格信息 
     * @support  array $services 服务信息 
     * @support  array $entend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 产品详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 删除产品
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 更新产品
     *
     * @support  int $id id [ require true ]
     * @support  string $name 产品名称 [ require true ]
     * @support  int $category_id 产品所属类目id [ require true ]
     * @support  string $main_img 主图 
     * @support  string $description 描述 
     * @support  string $eng_name 英文名称 
     * @support  int $mini_people_num 最小人数 
     * @support  int $max_people_num 最大人数 
     * @support  int $sort 排序 
     * @support  array $styles 风格信息 
     * @support  array $services 服务信息 
     * @support  array $entend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 产品列表
     *
     * @support  int $id 产品id 
     * @support  int $category_id 类目id 
     * @support  string $name 产品名(模糊查询) 
     * @support  int $page 当前页 
     * @support  int $page_size 页内条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductList () {
        return self::getClass()->getProductList();
    }

    /**
     * 上架产品
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upProduct (int $id) {
        return self::getClass()->upProduct([
            "id" => $id,
        ]);
    }

    /**
     * 下架产品
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function downProduct (int $id) {
        return self::getClass()->downProduct([
            "id" => $id,
        ]);
    }

    /**
     * 获取风格组
     *
     * @throws  \Exception
     * @return  array
     */
    public static function styleGroups () {
        return self::getClass()->styleGroups();
    }

    /**
     * 获取风格项
     *
     * @throws  \Exception
     * @return  array
     */
    public static function styleLabels () {
        return self::getClass()->styleLabels();
    }

    /**
     * 获取全部服务组
     *
     * @throws  \Exception
     * @return  array
     */
    public static function serviceGroups () {
        return self::getClass()->serviceGroups();
    }

    /**
     * 获取全部服务项
     *
     * @throws  \Exception
     * @return  array
     */
    public static function serviceLabels () {
        return self::getClass()->serviceLabels();
    }

    /**
     * 添加风格组
     *
     * @param  string $name  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addStyleGroup (string $name) {
        return self::getClass()->addStyleGroup([
            "name" => $name,
        ]);
    }

    /**
     * 添加风格项
     *
     * @param  string $name  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addStyleLabel (string $name) {
        return self::getClass()->addStyleLabel([
            "name" => $name,
        ]);
    }

    /**
     * 添加服务组
     *
     * @support  string $name  [ require true ]
     * @support  bool $multiple  [ require true ]
     * @support  bool $is_required  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addServiceGroup () {
        return self::getClass()->addServiceGroup();
    }

    /**
     * 添加服务项
     *
     * @param  string $name  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function addServiceLabel (string $name) {
        return self::getClass()->addServiceLabel([
            "name" => $name,
        ]);
    }

    /**
     * 根据产品ID获取产品价格列表
     *
     * @param  int $product_id 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productPriceListByProduct (int $product_id) {
        return self::getClass()->productPriceListByProduct([
            "product_id" => $product_id,
        ]);
    }

    /**
     * 根据服务ID获取服务价格列表
     *
     * @param  int $service_id 服务ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function servicePriceListByService (int $service_id) {
        return self::getClass()->servicePriceListByService([
            "service_id" => $service_id,
        ]);
    }

    /**
     * 添加产品价格
     *
     * @support  int $product_id  [ require true ]
     * @support  float $price  [Original type double] [ require true ]
     * @support  float $original_price  [Original type double] [ require true ]
     * @support  float $add_people_price  [Original type double] [ require true ]
     * @support  string $price_mode  
     * @throws  \Exception
     * @return  mixed
     */
    public static function createProductPrice () {
        return self::getClass()->createProductPrice();
    }

    /**
     * 更新产品价格
     *
     * @support  int $id  [ require true ]
     * @support  float $price  [Original type double] [ require true ]
     * @support  float $original_price  [Original type double] [ require true ]
     * @support  float $add_people_price  [Original type double] [ require true ]
     * @support  string $price_mode  
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateProductPrice () {
        return self::getClass()->updateProductPrice();
    }

    /**
     * 删除产品价格
     *
     * @param  int $id  [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteProductPrice (int $id) {
        return self::getClass()->deleteProductPrice([
            "id" => $id,
        ]);
    }

    /**
     * 绑定产品到门店
     *
     * @param  int $product_id  [ require true ]
     * @param  array $store_ids  [ require true ]
     * @param  int $price_id  [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindProductToStores (int $product_id, array $store_ids, int $price_id) {
        return self::getClass()->bindProductToStores([
            "product_id" => $product_id,
            "store_ids" => $store_ids,
            "price_id" => $price_id,
        ]);
    }

    /**
     * 添加服务价格
     *
     * @support  int $service_id  [ require true ]
     * @support  float $price  [Original type double] [ require true ]
     * @support  float $original_price  [Original type double] [ require true ]
     * @support  float $add_people_price  [Original type double] [ require true ]
     * @support  string $price_mode  
     * @throws  \Exception
     * @return  mixed
     */
    public static function createServicePrice () {
        return self::getClass()->createServicePrice();
    }

    /**
     * 更新服务价格
     *
     * @support  int $id  [ require true ]
     * @support  float $price  [Original type double] [ require true ]
     * @support  float $original_price  [Original type double] [ require true ]
     * @support  float $add_people_price  [Original type double] [ require true ]
     * @support  string $price_mode  
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateServicePrice () {
        return self::getClass()->updateServicePrice();
    }

    /**
     * 删除服务价格
     *
     * @param  int $id  [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteServicePrice (int $id) {
        return self::getClass()->deleteServicePrice([
            "id" => $id,
        ]);
    }

    /**
     * 绑定产品到门店
     *
     * @param  int $service_id  [ require true ]
     * @param  array $store_ids  [ require true ]
     * @param  int $price_id  [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindServiceToStores (int $service_id, array $store_ids, int $price_id) {
        return self::getClass()->bindServiceToStores([
            "service_id" => $service_id,
            "store_ids" => $store_ids,
            "price_id" => $price_id,
        ]);
    }

    /**
     * 获取产品详情
     *
     * @support  int $product_id 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function info () {
        return self::getClass()->info();
    }

    /**
     * 批量获取多个产品详情
     *
     * @support  array $product_ids 产品ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchDetail () {
        return self::getClass()->batchDetail();
    }

    /**
     * 获取门店所有产品
     *
     * @throws  \Exception
     * @return  array
     */
    public static function storeProduct () {
        return self::getClass()->storeProduct();
    }

    /**
     * 产品全局折扣计算
     *
     * @param  int $store_id  [ require true ]
     * @param  array $product_num_map  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productDiscountCalc (int $store_id, array $product_num_map) {
        return self::getClass()->productDiscountCalc([
            "store_id" => $store_id,
            "product_num_map" => $product_num_map,
        ]);
    }

    /**
     * 修改extend
     *
     * @support  int $id 类目id 
     * @support  array $extend 额外信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editExtend () {
        return self::getClass()->editExtend();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}