<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchOperateCouponByParams(array $params)
 */
class Dispatch {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量操作券码
     *
     * @param  string $stop_time 新的过期时间Y-m-d H:i:s [ require true ]
     * @param  array $arr 券码字符串数组,[&#039;abc&#039;,&#039;cba&#039;] [ require true ]
     * @param  string $coupon_type 券码类型，gift_card/preferential/interior_preferential [ require true ]
     * @param  string $operation 操作类型，delay/abolish [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchOperateCoupon (array $arr, string $stop_time, string $coupon_type, string $operation) {
        return self::getClass()->batchOperateCoupon([
            "arr" => $arr,
            "stop_time" => $stop_time,
            "coupon_type" => $coupon_type,
            "operation" => $operation,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Dispatch');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Dispatch');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}