<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method confirmByParams(array $params)
 * @method handTagByParams(array $params)
 * @method detailByParams(array $params)
 * @method refuseByParams(array $params)
 * @method moneyByParams(array $params)
 * @method reasonByParams(array $params)
 */
class OrderRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预约退款录入
     *
     * @support  int $subOrderId 子订单id [ require true ]
     * @support  int $scale 退款比例 
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账号 [ require true ]
     * @support  string $reason 退款理由 [ require true ]
     * @support  string $from 来源，用户预约端申请，后台申请 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 退款列表
     *
     * @support  int $search_type 查询时间类型【1:按照提交时间 2:按照退款时间】 
     * @support  string $refund_type 退款类型 
     * @support  string $start_time 开始时间 
     * @support  string $end_time 结束时间 
     * @support  int $store_id 门店id 
     * @support  int $refund_reason 退款原因类型 
     * @support  string $order_num 订单号 
     * @support  string $status 退款状态 
     * @support  int $page 页码 
     * @support  int $page_size 每页显示数量 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 退款处理
     *
     * @support  int $refund_id 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirm () {
        return self::getClass()->confirm();
    }

    /**
     * 手动标记退款
     *
     * @support  int $refund_id 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handTag () {
        return self::getClass()->handTag();
    }

    /**
     * 退款详情
     *
     * @support  int $refund_id 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 拒绝退款
     *
     * @support  int $refund_id 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refuse () {
        return self::getClass()->refuse();
    }

    /**
     * y
     *
     * @support  string $order_num 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function money () {
        return self::getClass()->money();
    }

    /**
     * 退款理由
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reason () {
        return self::getClass()->reason();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\OrderRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\OrderRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}