<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method createByParams(array $params)
 * @method createDsByParams(array $params)
 * @method bindUserByParams(array $params)
 * @method unbindUserByParams(array $params)
 * @method submitByParams(array $params)
 * @method cancelByParams(array $params)
 * @method paidByParams(array $params)
 * @method startByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单详情
     *
     * @param  int $id  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 创建订单（管理端开单）
     *
     * @support  int $store_id  [ require true ]
     * @support  int $user_id  
     * @support  string $user_phone  [ require true ]
     * @support  string $reserve_time  [ require true ]
     * @support  int $occupy_num  [ require true ]
     * @support  array $detail  [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 添加二销
     *
     * @support  int $order_id  [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createDs () {
        return self::getClass()->createDs();
    }

    /**
     * 绑定用户
     *
     * @param  int $id  [ require true ]
     * @param  int $user_id  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function bindUser (int $id, int $user_id) {
        return self::getClass()->bindUser([
            "id" => $id,
            "user_id" => $user_id,
        ]);
    }

    /**
     * 取消绑定用户
     *
     * @param  int $id  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function unbindUser (int $id) {
        return self::getClass()->unbindUser([
            "id" => $id,
        ]);
    }

    /**
     * 提交订单
     *
     * @param  int $id  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function submit (int $id) {
        return self::getClass()->submit([
            "id" => $id,
        ]);
    }

    /**
     * 取消订单
     *
     * @param  int $id  [ require true ]
     * @param  string $reason  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function cancel (int $id, string $reason) {
        return self::getClass()->cancel([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 完成支付
     *
     * @param  int $id  [ require true ]
     * @param  string $pay_type  [ require true ]
     * @param  string $payment_no  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function paid (int $id, string $pay_type, string $payment_no) {
        return self::getClass()->paid([
            "id" => $id,
            "pay_type" => $pay_type,
            "payment_no" => $payment_no,
        ]);
    }

    /**
     * 开始订单
     *
     * @param  int $id  [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function start (int $id) {
        return self::getClass()->start([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}