<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getGiftOrderRefundRecordByParams(array $params)
 * @method getOrderRefundRecordByParams(array $params)
 * @method transferGiftToCashByParams(array $params)
 */
class GiftCardRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单金额退款至礼品卡改退现金
     *
     * @support  int $refund_id 退款id [Original type uint] [ require true ]
     * @support  string $reason 转退备注 [ require true ]
     * @support  string $people 转退人姓名 [ require true ]
     * @support  string $account 转退账户 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取礼品卡转退的记录
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  int $orderId 订单id [Original type uint] [ require true ]
     * @param  int $status 转退状态1已退0未退2全部 [Original type uint] [ require true ]
     * @param  int $pageSize 每页显示条数 [Original type uint] [ require true ]
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getGiftOrderRefundRecord (string $orderNum = '', int $orderId = 0, int $status = 2, int $pageSize = 15, int $page = 1) {
        return self::getClass()->getGiftOrderRefundRecord([
            "orderNum" => $orderNum,
            "orderId" => $orderId,
            "status" => $status,
            "pageSize" => $pageSize,
            "page" => $page,
        ]);
    }

    /**
     * 获取订单退款的记录
     *
     * @param  string $orderNum 订单号 [ require true ]
     * @param  int $orderId 订单id [Original type uint] [ require true ]
     * @param  int $pageSize 每页显示条数 [Original type uint] [ require true ]
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderRefundRecord (string $orderNum = '', int $orderId = 0, int $pageSize = 15, int $page = 1) {
        return self::getClass()->getOrderRefundRecord([
            "orderNum" => $orderNum,
            "orderId" => $orderId,
            "pageSize" => $pageSize,
            "page" => $page,
        ]);
    }

    /**
     * 手动标记/原路转退(礼品卡转退现金)
     *
     * @param  int $changeRefundId 转退id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function transferGiftToCash (int $changeRefundId) {
        return self::getClass()->transferGiftToCash([
            "changeRefundId" => $changeRefundId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\GiftCardRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\GiftCardRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}