<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method removeByParams(array $params)
 * @method getStoreByServiceIdByParams(array $params)
 * @method getProductByServiceIdByParams(array $params)
 * @method getProductByStoreServiceIdByParams(array $params)
 * @method getStoreByServicePriceByParams(array $params)
 * @method getServiceByStoreIdByParams(array $params)
 */
class StoreService {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建门店-服务关联
     *
     * @support  array $store_ids 门店ids [ require true ]
     * @support  array $service_price_ids 升级服务价格ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 门店服务关联详情
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 删除门店服务关联信息
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function remove () {
        return self::getClass()->remove();
    }

    /**
     * 获取拥有当前服务的所有门店
     *
     * @support  int $service_id 升级服务id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreByServiceId () {
        return self::getClass()->getStoreByServiceId();
    }

    /**
     * 获取拥有当前服务的所有产品
     *
     * @support  int $service_id 升级服务id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductByServiceId () {
        return self::getClass()->getProductByServiceId();
    }

    /**
     * 获取当前门店内拥有当前服务的所有产品
     *
     * @support  int $store_id 门店id [ require true ]
     * @support  int $service_id 服务id [ require true ]
     * @support  int $page 当前页 
     * @support  int $page_size 页内条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getProductByStoreServiceId () {
        return self::getClass()->getProductByStoreServiceId();
    }

    /**
     * 获取当前服务价格绑定的所有门店
     *
     * @support  int $service_price_id 升级服务价格id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStoreByServicePrice () {
        return self::getClass()->getStoreByServicePrice();
    }

    /**
     * 获取当前门店所有服务
     *
     * @support  int $store_id 门店id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getServiceByStoreId () {
        return self::getClass()->getServiceByStoreId();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\StoreService');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\StoreService');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}