<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStockListByParams(array $params)
 * @method getStockDetailByPageByParams(array $params)
 * @method getStockDetailByParams(array $params)
 * @method allotByParams(array $params)
 */
class Stock {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 管理端-预消费卡库存列表查询
     *
     * @param  string $type 卡券类型gift_card/product_card [ require true ]
     * @support  int $operate_id cover_id/product_id [Original type uint] 
     * @param  int $store_id 门店id [Original type uint] [ require true ]
     * @support  int $page 页数 [Original type uint] 
     * @support  int $page_size 一页显示条数 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStockList (string $type, int $store_id) {
        return self::getClass()->getStockList([
            "type" => $type,
            "store_id" => $store_id,
        ]);
    }

    /**
     * 管理端-库存记录详情
     *
     * @param  int $id 库存记录id [Original type uint] [ require true ]
     * @param  string $type 卡券类型gift_card/product_card [ require true ]
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStockDetailByPage (int $id, string $type, int $page = 1, int $page_size = 20) {
        return self::getClass()->getStockDetailByPage([
            "id" => $id,
            "type" => $type,
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 管理端-库存记录详情
     *
     * @param  int $id 库存记录id [Original type uint] [ require true ]
     * @param  string $type 卡券类型gift_card/product_card [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStockDetail (int $id, string $type) {
        return self::getClass()->getStockDetail([
            "id" => $id,
            "type" => $type,
        ]);
    }

    /**
     * 管理端-预消费卡调拨
     *
     * @param  array $card_ids 调拨的卡di数组 [ require true ]
     * @param  int $store_id 调往的门店id [Original type uint] [ require true ]
     * @param  string $type 卡类型,gift_card/product_card [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function allot (array $card_ids, int $store_id, string $type) {
        return self::getClass()->allot([
            "card_ids" => $card_ids,
            "store_id" => $store_id,
            "type" => $type,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Stock');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Stock');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}