<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method indexByParams(array $params)
 * @method productsDetailByParams(array $params)
 * @method productDetailByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取门店产品列表
     *
     * @support  int $storeId 门店ID [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function index () {
        return self::getClass()->index();
    }

    /**
     * 获取多个产品详情
     *
     * @support  int $storeId 门店ID [Original type uint] 
     * @support  array $nodeIds 产品ID 
     * @throws  \Exception
     * @return  mixed
     */
    public static function productsDetail () {
        return self::getClass()->productsDetail();
    }

    /**
     * 获取产品详情
     *
     * @support  int $storeId 门店ID [Original type uint] 
     * @support  int $nodeId 产品ID [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function productDetail () {
        return self::getClass()->productDetail();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}