<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 */
class ProductTemplate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 原片分享模板文案记录
     *
     * @support  string $order_num 订单号 [ require true ]
     * @support  int $product_id 产品id [Original type uint] [ require true ]
     * @support  string $content 内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取模板存储的内容
     *
     * @support  string $reserve_time_start 开始时间 [ require true ]
     * @support  string $reserve_time_end 结束时间 [ require true ]
     * @support  string $product_name 产品名 
     * @support  int $uid 用户id 
     * @support  string $content 模板文字内容 
     * @support  string $store_name 门店名 
     * @support  bool $all 是否返回所有结果 
     * @support  int $page 页码 
     * @support  int $page_size 每页显示数量 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\ProductTemplate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\ProductTemplate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}