<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method abolishByParams(array $params)
 * @method detailByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method createLogAllByParams(array $params)
 * @method searchByParams(array $params)
 */
class GiftCards {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 生成礼品卡
     *
     * @support  string $title 记录标题 [ require true ]
     * @support  array $extend 拓展信息 
     * @support  string $type 卡类型，实体卡/虚拟卡,physical/virtual [ require true ]
     * @support  string $pay_type 支付方式 
     * @support  float $pay_money 支付金额 [Original type unsignedDouble] 
     * @support  string $buy_channel 售卖渠道 [ require true ]
     * @support  array $card_item 卡片信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新礼品卡信息
     *
     * @support  string $status 状态 
     * @support  array $card_ids 卡ids [Original type array&lt;int&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 礼品卡作废
     *
     * @support  string $status 状态 
     * @support  array $card_ids 卡ids [Original type array&lt;uint&gt;] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function abolish () {
        return self::getClass()->abolish();
    }

    /**
     * 获取礼品卡信息
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 获取礼品卡列表(分页)
     *
     * @support  int $id 礼品卡编号 [Original type uint] 
     * @support  string $status 状态 
     * @support  string $code 礼品码 
     * @support  int $create_log_id 生成记录id [Original type uint] 
     * @support  string $created_at_start 生成时间起 
     * @support  string $created_at_end 生成时间止 
     * @support  int $page 页码 
     * @support  int $page_size 每页条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取礼品卡列表(全部)
     *
     * @support  int $id 礼品卡编号 [Original type uint] 
     * @support  array $status 状态 
     * @support  string $code 礼品码 
     * @support  int $create_log_id 生成记录id [Original type uint] 
     * @support  string $created_at_start 生成时间起 
     * @support  string $created_at_end 生成时间止 
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 获取创建日志列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function createLogAll () {
        return self::getClass()->createLogAll();
    }

    /**
     * 搜索礼品卡
     *
     * @support  int $id 礼品卡编号 [Original type uint] 
     * @support  string $code 礼品码 
     * @support  string $status 查询状态inactivated(未激活)|activated(已激活)|used(已使用)|abolished(已作废)|expired(已过期) 
     * @support  string $mobile 手机号 
     * @support  int $page 分页 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function search () {
        return self::getClass()->search();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\GiftCards');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\GiftCards');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}