<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 */
class PayMax {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 拉卡拉进件
     *
     * @support  string $channelType 渠道类型(TP_MERCHANT:商户,TP_PERSONAL:个人) [ require true ]
     * @support  string $posType POS类型(WECHAT_PAY:扫码支付) [ require true ]
     * @support  string $merName 商户名称 [ require true ]
     * @support  string $bizName 商户经营名称 [ require true ]
     * @support  string $merLicenseNo 营业执照号 [ require true ]
     * @support  string $provinceCode 商户注册地址省代码 [ require true ]
     * @support  string $cityCode 商户注册地址市代码 [ require true ]
     * @support  string $countyCode 商户注册地址区代码 [ require true ]
     * @support  string $address 商户详细地址 [ require true ]
     * @support  string $bizContent 商户经营内容 [ require true ]
     * @support  string $crLicenceName 商户法人姓名 [ require true ]
     * @support  string $crLicenceNo 商户法人身份证号码 [ require true ]
     * @support  string $idCardExpire 法人身份证有效期 [ require true ]
     * @support  string $contactMobile 联系人手机号码 [ require true ]
     * @support  string $openningBankNo 开户行号 [ require true ]
     * @support  string $openningBankName 开户支行名称 [ require true ]
     * @support  string $clearingBankNo 清算行号 [ require true ]
     * @support  string $accountNo 账户号 [ require true ]
     * @support  string $accountName 账户名称 [ require true ]
     * @support  string $accountKind 账户性质(57：对公, 58：对私) [ require true ]
     * @support  string $idCard 入账人身份证号码 [ require true ]
     * @support  string $email 对账单邮箱 
     * @support  string $mccCode 行业代码 [ require true ]
     * @support  string $debitRate 借记卡手续费 [ require true ]
     * @support  array $array:wechatFees 扫码手续费集合 [ require true ]
     * @support  string $termNum 终端数量 [ require true ]
     * @support  string $termType 终端型号 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 拉卡拉进件修改
     *
     * @support  string $merchantId 商户id [ require true ]
     * @support  string $channelType 渠道类型(TP_MERCHANT:商户,TP_PERSONAL:个人) 
     * @support  string $posType POS类型(WECHAT_PAY:扫码支付) 
     * @support  string $merName 商户名称 
     * @support  string $bizName 商户经营名称 
     * @support  string $merLicenseNo 营业执照号 
     * @support  string $provinceCode 商户注册地址省代码 
     * @support  string $cityCode 商户注册地址市代码 
     * @support  string $countyCode 商户注册地址区代码 
     * @support  string $address 商户详细地址 
     * @support  string $bizContent 商户经营内容 
     * @support  string $crLicenceName 商户法人姓名 
     * @support  string $crLicenceNo 商户法人身份证号码 
     * @support  string $idCardExpire 法人身份证有效期 
     * @support  string $contactMobile 联系人手机号码 
     * @support  string $openningBankNo 开户行号 
     * @support  string $openningBankName 开户支行名称 
     * @support  string $clearingBankNo 清算行号 
     * @support  string $accountNo 账户号 
     * @support  string $accountName 账户名称 
     * @support  string $accountKind 账户性质(57：对公, 58：对私) 
     * @support  string $idCard 入账人身份证号码 
     * @support  string $email 对账单邮箱 
     * @support  string $mccCode 行业代码 
     * @support  string $debitRate 借记卡手续费 
     * @support  array $array:wechatFees 扫码手续费集合 
     * @support  string $termNum 终端数量 
     * @support  string $termType 终端型号 
     * @support  array $array:attachments 附件信息集合(仅修改可用) 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 拉卡拉进件列表
     *
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $num 每页数目 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $num = 10) {
        return self::getClass()->list([
            "page" => $page,
            "num" => $num,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\PayMax');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\PayMax');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}