<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method allByParams(array $params)
 */
class PreferentialType {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新增优惠券类型
     *
     * @support  float $money 立减金额(在减价优惠时传入) [Original type unsignedDouble] 
     * @support  float $discount 折扣(0~1,在折扣优惠时传入) [Original type unsignedDouble] 
     * @support  int $template_id 优惠券模板id [Original type uint] [ require true ]
     * @support  string $type 优惠券类型(discount_coupon[折扣优惠],decrease_coupon[减价优惠],product_coupon[产品优惠]) [ require true ]
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  int
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取优惠券类型列表
     *
     * @param  int $template_id 模板id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (int $template_id) {
        return self::getClass()->all([
            "template_id" => $template_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\PreferentialType');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\PreferentialType');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}