<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Extend;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getYbrConvertListByParams(array $params)
 * @method createCouponByParams(array $params)
 * @method getTokenByParams(array $params)
 */
class Preferential {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 衣邦人获取优惠码
     *
     * @param  string $startTime 开始日期 [ require true ]
     * @param  string $endTime 结束日期 [ require true ]
     * @param  string $code 优惠码 [ require true ]
     * @param  int $state 优惠码状态 [ require true ]
     * @param  bool $bound 是否绑定 [ require true ]
     * @param  int $page 页数 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @param  string $token token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getYbrConvertList (string $startTime = '', string $endTime = '', string $code = '', int $state = 0, bool $bound = false, int $page = 1, int $pageSize = 10, string $token = '') {
        return self::getClass()->getYbrConvertList([
            "startTime" => $startTime,
            "endTime" => $endTime,
            "code" => $code,
            "state" => $state,
            "bound" => $bound,
            "page" => $page,
            "pageSize" => $pageSize,
            "token" => $token,
        ]);
    }

    /**
     * 创建衣邦人兑换码
     *
     * @param  string $name 商户名 [ require true ]
     * @param  string $token token [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createCoupon (string $name = '', string $token = '') {
        return self::getClass()->createCoupon([
            "name" => $name,
            "token" => $token,
        ]);
    }

    /**
     * 获取token值
     *
     * @param  string $appId appId [ require true ]
     * @param  string $appSecret appSecret [ require true ]
     * @param  string $name 商户名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getToken (string $appId = '', string $appSecret = '', string $name = '') {
        return self::getClass()->getToken([
            "appId" => $appId,
            "appSecret" => $appSecret,
            "name" => $name,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Extend\Preferential');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Extend\Preferential');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}