<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method threeHourReminderByParams(array $params)
 * @method dayReminderByParams(array $params)
 * @method sendSNByParams(array $params)
 * @method sendOrderNotifyByParams(array $params)
 * @method sendGuardFairyPushByParams(array $params)
 * @method sendCityHighAwardPushByParams(array $params)
 * @method samplePhotoExpireNoticeByParams(array $params)
 * @method performanceShotDailyByParams(array $params)
 * @method reservationLogByParams(array $params)
 * @method reservationChangeByParams(array $params)
 * @method refreshSessionByParams(array $params)
 * @method birthGiftByParams(array $params)
 */
class Cron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每十分钟执行一次 查询有多少用户需要发送提醒
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function threeHourReminder () {
        return self::getClass()->threeHourReminder();
    }

    /**
     * 每天11点-18点每小时执行一次 查询有多少用户需要发送提醒
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function dayReminder () {
        return self::getClass()->dayReminder();
    }

    /**
     * 每5分钟执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendSN () {
        return self::getClass()->sendSN();
    }

    /**
     * 每天11-18的每次半点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendOrderNotify () {
        return self::getClass()->sendOrderNotify();
    }

    /**
     * 每天10点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendGuardFairyPush () {
        return self::getClass()->sendGuardFairyPush();
    }

    /**
     * 6.22 19点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendCityHighAwardPush () {
        return self::getClass()->sendCityHighAwardPush();
    }

    /**
     * 每天10点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function samplePhotoExpireNotice () {
        return self::getClass()->samplePhotoExpireNotice();
    }

    /**
     * 每天2点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function performanceShotDaily () {
        return self::getClass()->performanceShotDaily();
    }

    /**
     * 每天1点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reservationLog () {
        return self::getClass()->reservationLog();
    }

    /**
     * 每天11点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reservationChange () {
        return self::getClass()->reservationChange();
    }

    /**
     * 每月的1号15号2点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function refreshSession () {
        return self::getClass()->refreshSession();
    }

    /**
     * 每天9点执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function birthGift () {
        return self::getClass()->birthGift();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\Cron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\Cron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}