<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateMobileByParams(array $params)
 * @method detailByParams(array $params)
 * @method flowByParams(array $params)
 * @method listByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 增加一条用户信息
     *
     * @support  string $phone 手机号 [ require true ]
     * @support  string $sex 用户性别(male男|female女) [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 修改用户手机
     *
     * @support  string $new_phone 新手机号 
     * @support  string $old_phone 旧手机号 
     * @support  string $code 验证码 
     * @support  string $certificate 用户沟通凭证 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateMobile () {
        return self::getClass()->updateMobile();
    }

    /**
     * 获取用户信息
     *
     * @support  int $id 用户id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 获取用户流水
     *
     * @support  int $id 用户id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function flow () {
        return self::getClass()->flow();
    }

    /**
     * 获取用户列表
     *
     * @support  string $nickname 用户昵称 
     * @support  string $level 会员等级 
     * @support  int $times 消费次数 
     * @support  int $interval 消费间隔 
     * @support  string $create_time_start 注册时间-开始 
     * @support  string $create_time_end 注册时间-结束 
     * @support  int $page 页码 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}