<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allChildrenByParams(array $params)
 * @method allProductsByParams(array $params)
 * @method allNodesProductsByParams(array $params)
 * @method addNodeByParams(array $params)
 * @method addProductByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method restoreByParams(array $params)
 * @method hiddenByParams(array $params)
 * @method showByParams(array $params)
 */
class ProductClassification {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有下级节点
     *
     * @support  int $nodeId 节点id [Original type uint] 
     * @support  bool $includeHidden 是否包含隐藏 
     * @support  bool $includeDelete 是否包含删除 
     * @throws  \Exception
     * @return  mixed
     */
    public static function allChildren () {
        return self::getClass()->allChildren();
    }

    /**
     * 获取所有下级产品
     *
     * @support  int $nodeId 节点id [Original type uint] 
     * @support  bool $includeHidden 是否包含隐藏 
     * @support  bool $includeDelete 是否包含删除 
     * @throws  \Exception
     * @return  mixed
     */
    public static function allProducts () {
        return self::getClass()->allProducts();
    }

    /**
     * 获取所有下级产品/节点
     *
     * @support  int $nodeId 节点ID [Original type uint] 
     * @support  bool $includeHidden 包含隐藏节点 
     * @support  bool $includeDelete 包含下线节点 
     * @throws  \Exception
     * @return  mixed
     */
    public static function allNodesProducts () {
        return self::getClass()->allNodesProducts();
    }

    /**
     * 创建一个Node节点
     *
     * @support  int $parentNodeId 父节点id [Original type uint] 
     * @support  bool $isHidden 是否为隐藏节点 
     * @support  string $name 节点名称 [ require true ]
     * @support  string $realName 节点真实名称 
     * @support  int $sort 排序顺序 [Original type uint] 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addNode () {
        return self::getClass()->addNode();
    }

    /**
     * 创建一个产品节点
     *
     * @support  int $parentNodeId 父节点id [Original type uint] 
     * @support  bool $isHidden 是否为隐藏节点 
     * @support  string $name 节点名称 [ require true ]
     * @support  string $realName 节点真实名称 
     * @support  int $sort 排序顺序 [Original type uint] 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProduct () {
        return self::getClass()->addProduct();
    }

    /**
     * 修改节点
     *
     * @support  int $nodeId 节点id [Original type uint] 
     * @support  string $name 节点名称 
     * @support  string $realName 节点真实名称 
     * @support  int $sort 排序顺序 [Original type uint] 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  array
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 删除节点
     *
     * @support  int $nodeId 节点id [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function delete () {
        return self::getClass()->delete();
    }

    /**
     * 恢复节点
     *
     * @support  int $nodeId 节点id [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function restore () {
        return self::getClass()->restore();
    }

    /**
     * 隐藏节点
     *
     * @support  int $nodeId 节点id [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function hidden () {
        return self::getClass()->hidden();
    }

    /**
     * 显示节点
     *
     * @support  int $nodeId 节点id [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function show () {
        return self::getClass()->show();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductClassification');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductClassification');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}