<?php
namespace Mainto\Bridge\Invokes\HimoProduct\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method createOrderByParams(array $params)
 * @method ownListByParams(array $params)
 * @method infoByParams(array $params)
 * @method createWechatCardByParams(array $params)
 * @method getCardByWechatCardByParams(array $params)
 * @method bindFromWechatByParams(array $params)
 * @method bindBackByParams(array $params)
 * @method coverListByParams(array $params)
 * @method topicListByParams(array $params)
 * @method previewByParams(array $params)
 * @method setCoverByParams(array $params)
 * @method balanceByParams(array $params)
 * @method chargeByParams(array $params)
 * @method bindByParams(array $params)
 * @method orderListByParams(array $params)
 * @method orderDetailByParams(array $params)
 * @method transactionListByParams(array $params)
 * @method chargeRecordByParams(array $params)
 * @method payInfoByParams(array $params)
 * @method payDsByParams(array $params)
 */
class GiftCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 礼品卡列表
     *
     * @support  int $page 分页 [Original type uint] 
     * @support  int $page_size 每页数据量 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 用户购买礼品卡
     *
     * @support  float $pay_money 实付 [Original type double] [ require true ]
     * @support  array $card_item 卡片信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createOrder () {
        return self::getClass()->createOrder();
    }

    /**
     * 获取用户礼品卡列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function ownList () {
        return self::getClass()->ownList();
    }

    /**
     * 获取用户礼品卡信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function info () {
        return self::getClass()->info();
    }

    /**
     * 获取礼品卡微信卡券
     *
     * @support  string $code 礼品卡code [ require true ]
     * @support  string $open_id 微信标识 [ require true ]
     * @support  string $scene 场景 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createWechatCard () {
        return self::getClass()->createWechatCard();
    }

    /**
     * 通过微信卡券返回码获取礼品卡信息
     *
     * @support  string $scene 场景 [ require true ]
     * @support  string $encrypt_code 微信加密的返回码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCardByWechatCard () {
        return self::getClass()->getCardByWechatCard();
    }

    /**
     * 充值礼品卡并从微信卡包移除
     *
     * @support  string $code 礼品卡code [ require true ]
     * @support  string $scene 场景 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindFromWechat () {
        return self::getClass()->bindFromWechat();
    }

    /**
     * 绑定礼品卡(用于领取到微信卡包失败)
     *
     * @support  string $code 礼品码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindBack () {
        return self::getClass()->bindBack();
    }

    /**
     * 获取用户可用封面信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function coverList () {
        return self::getClass()->coverList();
    }

    /**
     * 获取礼品卡类型信息
     *
     * @support  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function topicList () {
        return self::getClass()->topicList();
    }

    /**
     * 获取预览信息
     *
     * @support  string $code 兑换码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function preview () {
        return self::getClass()->preview();
    }

    /**
     * 设置cover
     *
     * @support  int $cover_id 礼品卡id [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function setCover () {
        return self::getClass()->setCover();
    }

    /**
     * 获取用户余额
     *
     * @throws  \Exception
     * @return  int
     */
    public static function balance () {
        return self::getClass()->balance();
    }

    /**
     * 充值礼品码
     *
     * @support  string $code 礼品码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function charge () {
        return self::getClass()->charge();
    }

    /**
     * 绑定礼品码(微信卡券未领取后)
     *
     * @support  string $code 礼品码 [ require true ]
     * @support  string $scene 场景 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function bind () {
        return self::getClass()->bind();
    }

    /**
     * 获取礼品卡订单列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderList () {
        return self::getClass()->orderList();
    }

    /**
     * 获取单个礼品卡订单详情
     *
     * @support  string $order_num 礼品卡订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderDetail () {
        return self::getClass()->orderDetail();
    }

    /**
     * pay_for 订单 =&gt; order, 二销 =&gt; ds
     *
     * @throws  \Exception
     * @return  array
     */
    public static function transactionList () {
        return self::getClass()->transactionList();
    }

    /**
     * 获取礼品卡充值记录
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function chargeRecord () {
        return self::getClass()->chargeRecord();
    }

    /**
     * 获取支付状态
     *
     * @support  int $id 二销id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function payInfo () {
        return self::getClass()->payInfo();
    }

    /**
     * 使用礼品卡支付
     *
     * @support  int $id 二销id [Original type uint] [ require true ]
     * @support  int $ts 时间戳 [Original type uint] [ require true ]
     * @support  float $money 金额 [Original type unsignedDouble] [ require true ]
     * @support  string $sign 签名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function payDs () {
        return self::getClass()->payDs();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'User\GiftCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'User\GiftCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}