<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method treeChildrenByParams(array $params)
 * @method childrenByParams(array $params)
 * @method addChildNodeByParams(array $params)
 * @method updateChildNodeByParams(array $params)
 * @method deleteChildNodeByParams(array $params)
 * @method restoreChildNodeByParams(array $params)
 * @method hideChildNodeByParams(array $params)
 * @method showChildNodeByParams(array $params)
 * @method batchAddNodeByParams(array $params)
 * @method treeMaintoChildrenByParams(array $params)
 * @method addMaintoChildNodeByParams(array $params)
 * @method updateMaintoChildNodeByParams(array $params)
 * @method deleteMaintoChildNodeByParams(array $params)
 * @method restoreMaintoChildNodeByParams(array $params)
 * @method hideMaintoChildNodeByParams(array $params)
 * @method showMaintoChildNodeByParams(array $params)
 * @method batchMaintoAddNodeByParams(array $params)
 * @method nodeNameByParams(array $params)
 */
class ProductTree {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * nodeType代表当前nodeId所往下查询的深度(例如当前node是product nodeType为addition 则返回的数为从product到addition的三级树)
     *
     * @support  int $nodeId 节点ID [Original type uint] 
     * @support  string $nodeType 节点类型 
     * @support  bool $includeHidden 包含隐藏节点 
     * @support  bool $includeDelete 包含下线节点 
     * @throws  \Exception
     * @return  mixed
     */
    public static function treeChildren () {
        return self::getClass()->treeChildren();
    }

    /**
     * 获取下级节点, 非树状模式
     *
     * @support  int $nodeId 节点ID [Original type uint] 
     * @support  string $nodeType 节点类型 
     * @support  bool $includeHidden 包含隐藏节点 
     * @support  bool $includeDelete 包含下线节点 
     * @throws  \Exception
     * @return  mixed
     */
    public static function children () {
        return self::getClass()->children();
    }

    /**
     * 添加下级节点
     *
     * @support  int $parentNodeId 父节点 [Original type uint] 
     * @support  string $nodeType 节点类型 [ require true ]
     * @support  bool $isHidden 是否为隐藏节点 
     * @support  string $name 节点名称 [ require true ]
     * @support  string $realName 节点真实名称 
     * @support  int $includeNum 包含子产品数量, 仅 AdditionNode 有效, 0或-1为不强制包含子产品 [Original type uint] 
     * @support  string $engName 节点英文名称 
     * @support  string $fullName 完整名称 
     * @support  int $minPeople 最小人数 [Original type uint] 
     * @support  int $maxPeople 最大人数 [Original type uint] 
     * @support  int $sort 排序顺序 [Original type uint] 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addChildNode () {
        return self::getClass()->addChildNode();
    }

    /**
     * 修改下级节点
     *
     * @support  int $nodeId 节点id [Original type uint] 
     * @support  string $name 节点名称 
     * @support  string $realName 节点真实名称 
     * @support  string $engName 节点英文名称 [ require true ]
     * @support  int $includeNum 包含子产品数量, 仅 AdditionNode 有效, -1为不更改, 0为不包含子产品 [Original type uint] 
     * @support  string $fullName 完整名称 
     * @support  int $minPeople 最小人数 [Original type uint] 
     * @support  int $maxPeople 最大人数 [Original type uint] 
     * @support  int $sort 排序顺序 [Original type uint] 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateChildNode () {
        return self::getClass()->updateChildNode();
    }

    /**
     * 删除下级节点
     *
     * @support  int $nodeId 父节点 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteChildNode () {
        return self::getClass()->deleteChildNode();
    }

    /**
     * 恢复节点
     *
     * @support  int $nodeId 父节点 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function restoreChildNode () {
        return self::getClass()->restoreChildNode();
    }

    /**
     * 隐藏节点
     *
     * @support  int $nodeId 父节点 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function hideChildNode () {
        return self::getClass()->hideChildNode();
    }

    /**
     * 显示节点
     *
     * @support  int $nodeId 父节点 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function showChildNode () {
        return self::getClass()->showChildNode();
    }

    /**
     * 批量添加节点
     *
     * @support  int $parentNodeId 父节点 [Original type uint] 
     * @support  array $node 节点信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchAddNode () {
        return self::getClass()->batchAddNode();
    }

    /**
     * 获取缦图摄影下级节点, 树状模式
     *
     * @support  int $nodeId 节点ID [Original type uint] 
     * @support  string $nodeType 节点类型 
     * @support  bool $includeHidden 包含隐藏节点 
     * @support  bool $includeDelete 包含下线节点 
     * @throws  \Exception
     * @return  mixed
     */
    public static function treeMaintoChildren () {
        return self::getClass()->treeMaintoChildren();
    }

    /**
     * 添加缦图摄影下级节点
     *
     * @support  int $parentNodeId 父节点 [Original type uint] 
     * @support  string $nodeType 节点类型 [ require true ]
     * @support  bool $isHidden 是否为隐藏节点 
     * @support  string $name 节点名称 [ require true ]
     * @support  string $realName 节点真实名称 
     * @support  int $includeNum 包含子产品数量, 仅 AdditionNode 有效, 0或-1为不强制包含子产品 [Original type uint] 
     * @support  string $engName 节点英文名称 
     * @support  string $fullName 完整名称 
     * @support  int $minPeople 最小人数 [Original type uint] 
     * @support  int $maxPeople 最大人数 [Original type uint] 
     * @support  int $sort 排序顺序 [Original type uint] 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addMaintoChildNode () {
        return self::getClass()->addMaintoChildNode();
    }

    /**
     * 修改缦图摄影下级节点
     *
     * @support  int $nodeId 节点id [Original type uint] 
     * @support  string $name 节点名称 
     * @support  string $realName 节点真实名称 
     * @support  string $engName 节点英文名称 [ require true ]
     * @support  int $includeNum 包含子产品数量, 仅 AdditionNode 有效, -1为不更改, 0为不包含子产品 [Original type uint] 
     * @support  string $fullName 完整名称 
     * @support  int $minPeople 最小人数 [Original type uint] 
     * @support  int $maxPeople 最大人数 [Original type uint] 
     * @support  int $sort 排序顺序 [Original type uint] 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateMaintoChildNode () {
        return self::getClass()->updateMaintoChildNode();
    }

    /**
     * 删除缦图摄影下级节点
     *
     * @support  int $nodeId 父节点 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteMaintoChildNode () {
        return self::getClass()->deleteMaintoChildNode();
    }

    /**
     * 恢复缦图摄影节点
     *
     * @support  int $nodeId 父节点 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function restoreMaintoChildNode () {
        return self::getClass()->restoreMaintoChildNode();
    }

    /**
     * 隐藏缦图摄影节点
     *
     * @support  int $nodeId 父节点 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function hideMaintoChildNode () {
        return self::getClass()->hideMaintoChildNode();
    }

    /**
     * 显示缦图摄影节点
     *
     * @support  int $nodeId 父节点 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function showMaintoChildNode () {
        return self::getClass()->showMaintoChildNode();
    }

    /**
     * 批量添加缦图摄影节点
     *
     * @support  int $parentNodeId 父节点 [Original type uint] 
     * @support  array $node 节点信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchMaintoAddNode () {
        return self::getClass()->batchMaintoAddNode();
    }

    /**
     * 获取产品名
     *
     * @support  array $nodeIds 节点 [ require true ]
     * @support  bool $includeHidden 是否包含隐藏 
     * @support  bool $includeDelete 是否包含删除 
     * @throws  \Exception
     * @return  mixed
     */
    public static function nodeName () {
        return self::getClass()->nodeName();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\ProductTree');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\ProductTree');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}