<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchCreateByParams(array $params)
 * @method updateByParams(array $params)
 * @method abolishedByParams(array $params)
 * @method usedByParams(array $params)
 * @method listByParams(array $params)
 * @method allByParams(array $params)
 * @method searchByParams(array $params)
 * @method createLogListByParams(array $params)
 */
class PreferentialCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 批量生成优惠券
     *
     * @support  string $title 生成原因 [ require true ]
     * @support  int $type_id 优惠类型id [Original type uint] [ require true ]
     * @support  int $template_id 模板id [Original type uint] [ require true ]
     * @support  int $count 创建数量 [Original type uint] [ require true ]
     * @support  float $ori_money 原金额 [Original type unsignedDouble] [ require true ]
     * @support  int $month_count 月份数量 [Original type uint] 
     * @support  string $stop_usage 结束使用时间 
     * @support  string $start_usage 开始生效时间 
     * @support  float $pay_money 收金额 [Original type unsignedDouble] 
     * @support  string $buy_channel 购买渠道 
     * @support  array $extend 拓展信息 
     * @support  string $card_init_status 优惠券状态(inactivated[未激活],activated[未使用],abolished[已作废],expired[已过期]) 
     * @support  bool $active_flush_stop 是否激活后更新有效期 
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate () {
        return self::getClass()->batchCreate();
    }

    /**
     * 更新优惠券状态
     *
     * @support  array $preferential_ids 优惠码ids [ require true ]
     * @support  string $to_status 更改为的状态 
     * @support  array $extend 拓展信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 优惠券作废
     *
     * @support  array $preferential_ids 优惠码ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function abolished () {
        return self::getClass()->abolished();
    }

    /**
     * 优惠券标记为已使用
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function used () {
        return self::getClass()->used();
    }

    /**
     * 获取兑换码列表(分页)
     *
     * @support  int $user_id 用户ID [Original type uint] 
     * @support  string $type 优惠券类型 
     * @support  string $mobile 手机号 
     * @support  string $created_at_start 生成时间起 
     * @support  string $created_at_end 生成时间止 
     * @support  string $used_at_start 使用时间起 
     * @support  string $used_at_end 使用时间止 
     * @support  string $status 状态 
     * @support  string $code 兑换码 
     * @support  int $create_log_id 创建记录id [Original type uint] 
     * @support  bool $with_type_info 包含卡面信息 
     * @support  int $page 页码 
     * @support  int $page_size 每页条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 获取兑换码列表(所有)
     *
     * @support  string $mobile 手机号 
     * @support  string $created_at_start 生成时间起 
     * @support  string $created_at_end 生成时间止 
     * @support  string $used_at_start 使用时间起 
     * @support  string $used_at_end 使用时间止 
     * @support  string $status 状态 
     * @support  string $code 兑换码 
     * @support  int $create_log_id 创建记录id [Original type uint] 
     * @support  bool $with_type_info 包含卡面信息 
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * 优惠券单个码查询
     *
     * @support  string $mobile 手机号 
     * @support  string $status 状态 
     * @support  string $code 兑换码 
     * @support  int $page 页码 
     * @support  int $page_size 每页条数 
     * @support  bool $with_type_info 包含卡面信息 
     * @throws  \Exception
     * @return  array
     */
    public static function search () {
        return self::getClass()->search();
    }

    /**
     * 渠道领券查询
     *
     * @support  string $ids 记录ids 
     * @support  string $title 标题 
     * @support  string $channel 渠道号 
     * @throws  \Exception
     * @return  array
     */
    public static function createLogList () {
        return self::getClass()->createLogList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\PreferentialCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\PreferentialCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}