<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method priceByParams(array $params)
 * @method listByParams(array $params)
 * @method wholeListByParams(array $params)
 * @method invoiceListByParams(array $params)
 * @method orderAssistantByParams(array $params)
 * @method dsAssistantByParams(array $params)
 * @method offlineAssistantByParams(array $params)
 * @method detailByParams(array $params)
 * @method cloudOrderDetailByParams(array $params)
 * @method orderProductByParams(array $params)
 * @method updateByParams(array $params)
 * @method updateUserByParams(array $params)
 * @method unbindByParams(array $params)
 * @method changeStoreByParams(array $params)
 * @method changePayTypeByParams(array $params)
 * @method changeReserveTimeByParams(array $params)
 * @method closeOrderByParams(array $params)
 * @method updateNoteByParams(array $params)
 * @method updateProductByParams(array $params)
 * @method startByParams(array $params)
 * @method canChangeProductByParams(array $params)
 * @method finishOrderByParams(array $params)
 * @method recoverOrderByParams(array $params)
 * @method resetWorkloadByParams(array $params)
 * @method removeDsByParams(array $params)
 * @method changeDsPayTypeByParams(array $params)
 * @method createDsByParams(array $params)
 * @method operationRecordByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @support  string $phone 手机号 [ require true ]
     * @support  string $name 顾客姓名 [ require true ]
     * @support  string $order_time 预约时间,2018-11-05 10:00:00 [ require true ]
     * @support  array $product_group 产品集合 [ require true ]
     * @support  string $pay_status 支付状态 
     * @support  string $pay_type 支付类型 [ require true ]
     * @support  float $money 实际支付金额 [Original type double] [ require true ]
     * @support  string $sex 性别，male男female女 [ require true ]
     * @support  string $discount_code 折扣码 
     * @support  float $special_discount 特殊优惠金额 [Original type double] 
     * @support  string $birth 日期，1995-08-01 
     * @support  string $order_type 订单类型 
     * @support  string $note 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 获取订单产品价格
     *
     * @support  array $product_group 产品集合 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function price () {
        return self::getClass()->price();
    }

    /**
     * 获取订单列表
     *
     * @support  string $mobile 手机号 
     * @support  string $user_name 客户姓名 
     * @support  string $order_num 订单号 
     * @support  string $status 订单状态 
     * @support  string $origin 订单来源 
     * @support  string $reserve_time_start 预约开始时间 
     * @support  string $reserve_time_end 预约结束时间 
     * @support  string $sort_field 排序字段 
     * @support  int $page 页数 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 全局订单列表
     *
     * @support  string $mobile 手机号 
     * @support  string $user_name 客户姓名 
     * @support  string $order_num 订单号 
     * @support  int $page 页数 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function wholeList () {
        return self::getClass()->wholeList();
    }

    /**
     * 可开发票订单列表
     *
     * @support  string $mobile 手机号 
     * @support  string $order_num 订单号 
     * @support  int $page 页数 
     * @support  int $page_size 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function invoiceList () {
        return self::getClass()->invoiceList();
    }

    /**
     * 查账助手(营业额)
     *
     * @support  string $start_at 开始时间 
     * @support  string $end_at 结束时间 
     * @support  string $pay_type 支付方式 
     * @support  string $type 线上线下类型online|offline 
     * @support  int $page 分页 [Original type uint] 
     * @support  int $page_size 每页数据条数 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function orderAssistant () {
        return self::getClass()->orderAssistant();
    }

    /**
     * 查账助手(二销)
     *
     * @support  string $start_at 开始时间 
     * @support  string $end_at 结束时间 
     * @support  string $pay_type 支付方式 
     * @support  string $type 线上线下类型online|offline 
     * @throws  \Exception
     * @return  mixed
     */
    public static function dsAssistant () {
        return self::getClass()->dsAssistant();
    }

    /**
     * 查账助手(线下收入)
     *
     * @support  string $start_at 开始时间 
     * @support  string $end_at 结束时间 
     * @support  string $pay_type 支付方式 
     * @support  string $type 线上线下类型online|offline 
     * @support  int $page 分页 [Original type uint] 
     * @support  int $page_size 每页数据条数 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function offlineAssistant () {
        return self::getClass()->offlineAssistant();
    }

    /**
     * 订单详情
     *
     * @support  int $id 订单id [Original type uint] 
     * @support  string $order_num 订单编号 
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 云端订单详情
     *
     * @support  string $order_num 订单编号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cloudOrderDetail () {
        return self::getClass()->cloudOrderDetail();
    }

    /**
     * 获取订单所有产品
     *
     * @param  int $id 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function orderProduct (int $id) {
        return self::getClass()->orderProduct([
            "id" => $id,
        ]);
    }

    /**
     * 修改订单信息
     *
     * @support  int $id 订单id [ require true ]
     * @support  string $birthday 生日 
     * @support  string $sex 性别 
     * @support  string $email 邮箱 
     * @support  string $user_name 用户姓名 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 修改订单所属用户
     *
     * @support  int $order_num 订单编号 [ require true ]
     * @support  string $phone 新绑定用户的手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateUser () {
        return self::getClass()->updateUser();
    }

    /**
     * 解除绑定
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unbind (int $order_id) {
        return self::getClass()->unbind([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 订单转门店
     *
     * @support  int $old_order_id 原订单ID [ require true ]
     * @support  string $reserve_time 预约时间 
     * @support  string $note 转门店备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeStore () {
        return self::getClass()->changeStore();
    }

    /**
     * 修改支付方式
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $pay_type 支付方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changePayType () {
        return self::getClass()->changePayType();
    }

    /**
     * 修改预约时间
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  string $reserve_time 预约时间 
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeReserveTime () {
        return self::getClass()->changeReserveTime();
    }

    /**
     * 关闭订单
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  string $reason 原因 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrder (int $order_id, string $reason) {
        return self::getClass()->closeOrder([
            "order_id" => $order_id,
            "reason" => $reason,
        ]);
    }

    /**
     * 管理端修改订单备注
     *
     * @support  int $id 订单ID [ require true ]
     * @support  string $note 订单备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateNote () {
        return self::getClass()->updateNote();
    }

    /**
     * 修改订单产品
     *
     * @support  int $order_id 订单id 
     * @support  int $old_pid 老产品id 
     * @support  int $new_pid 新产品id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateProduct () {
        return self::getClass()->updateProduct();
    }

    /**
     * 开始订单流程
     *
     * @support  int $id 订单id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function start () {
        return self::getClass()->start();
    }

    /**
     * 可修改的产品列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function canChangeProduct () {
        return self::getClass()->canChangeProduct();
    }

    /**
     * 管理端完成订单
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  array $work_load 员工工作量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishOrder (int $order_id, array $work_load) {
        return self::getClass()->finishOrder([
            "order_id" => $order_id,
            "work_load" => $work_load,
        ]);
    }

    /**
     * 管理端恢复订单
     *
     * @support  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function recoverOrder () {
        return self::getClass()->recoverOrder();
    }

    /**
     * 重新设置工作量
     *
     * @support  int $order_id 订单id [ require true ]
     * @support  array $work_loads 员工工作量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function resetWorkload () {
        return self::getClass()->resetWorkload();
    }

    /**
     * 管理端删除二销
     *
     * @support  int $sale_id sale_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeDs () {
        return self::getClass()->removeDs();
    }

    /**
     * 管理端修改二销支付方式
     *
     * @param  int $sale_id sale_id [ require true ]
     * @param  string $pay_type 支付方式 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeDsPayType (int $sale_id, string $pay_type) {
        return self::getClass()->changeDsPayType([
            "sale_id" => $sale_id,
            "pay_type" => $pay_type,
        ]);
    }

    /**
     * 管理端创建二销
     *
     * @param  int $order_id 订单id [ require true ]
     * @param  string $ds_type ds类型 [ require true ]
     * @param  int $staff_id 员工id [ require true ]
     * @param  int $old_pid 老产品id [ require true ]
     * @param  array $product_group 产品组 [ require true ]
     * @support  int $people_num 拍摄人数 
     * @support  string $pay_type 支付类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createDs (int $order_id, string $ds_type, int $staff_id, array $product_group, int $old_pid = 0) {
        return self::getClass()->createDs([
            "order_id" => $order_id,
            "ds_type" => $ds_type,
            "staff_id" => $staff_id,
            "product_group" => $product_group,
            "old_pid" => $old_pid,
        ]);
    }

    /**
     * 管理端查询订单操作记录
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function operationRecord (int $order_id) {
        return self::getClass()->operationRecord([
            "order_id" => $order_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}