<?php
namespace Mainto\Bridge\Invokes\HimoProduct\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method confirmByParams(array $params)
 * @method handTagByParams(array $params)
 * @method detailByParams(array $params)
 * @method refuseByParams(array $params)
 * @method moneyByParams(array $params)
 * @method otherByParams(array $params)
 * @method processOtherByParams(array $params)
 * @method reasonByParams(array $params)
 */
class OrderRefund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预约退款录入
     *
     * @support  string $order_num 订单编号 
     * @support  string $order_id 订单id 
     * @support  string $refund_type 退款类型 [ require true ]
     * @support  float $refund_money 退款金额 [Original type double] [ require true ]
     * @support  string $refund_part 退款部分 
     * @support  int $refund_goods_id 其他退款类型需要的商品ID 
     * @support  string $refund_content 退款内容 (只有退款至礼品卡会使用此字段 : all : 全部 order: 初始支付 ds_all: 全部二销，{$ds_sku_id} : ds 产品id) 
     * @support  string $refund_people 退款人 [ require true ]
     * @support  string $refund_account 退款账户 [ require true ]
     * @support  int $refund_scale 退款比例 [ require true ]
     * @support  int $refund_reason 退款原因 [ require true ]
     * @support  bool $is_staff_pay 是否为伙伴垫付 
     * @support  bool $is_refund_card 是否退券 
     * @support  string $refund_note 退款备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 退款列表
     *
     * @support  int $time_type 查询时间类型【1:按照提交时间 2:按照退款时间】 
     * @support  string $refund_type 退款类型 
     * @support  string $start_time 开始时间 
     * @support  string $end_time 结束时间 
     * @support  int $store_id 门店id 
     * @support  int $refund_reason 退款原因类型 
     * @support  string $order_num 订单号 
     * @support  string $status 退款状态 
     * @support  int $page 页码 
     * @support  int $page_size 每页显示数量 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 退款处理
     *
     * @support  int $refund_id 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirm () {
        return self::getClass()->confirm();
    }

    /**
     * 手动标记退款
     *
     * @support  int $refund_id 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handTag () {
        return self::getClass()->handTag();
    }

    /**
     * 退款详情
     *
     * @support  int $refund_id 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 拒绝退款
     *
     * @support  int $refund_id 退款id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function refuse () {
        return self::getClass()->refuse();
    }

    /**
     * y
     *
     * @support  string $order_num 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function money () {
        return self::getClass()->money();
    }

    /**
     * 其它退款录入
     *
     * @support  float $refund_money 退款金额 [Original type double] [ require true ]
     * @support  int $refund_goods_id 其他退款类型需要的商品ID 
     * @support  string $refund_people 退款人 [ require true ]
     * @support  string $refund_account 退款账户 [ require true ]
     * @support  int $refund_scale 退款比例 [ require true ]
     * @support  int $refund_reason 退款原因 [ require true ]
     * @support  bool $is_staff_pay 是否为伙伴垫付 
     * @support  string $refund_note 退款备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function other () {
        return self::getClass()->other();
    }

    /**
     * 处理其他退款
     *
     * @support  int $refund_id 退款id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function processOther () {
        return self::getClass()->processOther();
    }

    /**
     * 退款理由
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function reason () {
        return self::getClass()->reason();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('HimoProduct', 'Admin\OrderRefund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('HimoProduct', 'Admin\OrderRefund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}